/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.model;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDocFile;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntityRepositoryType;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabelPath;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapDocsEntity {
    protected OlapDocsEntityRepositoryType repositoryType;
    private String uuid;
    private String caption;
    @Nullable
    private Date lastModified;
    private List<OlapDocsSharing> sharings;
    private String nameUrl;
    private OlapPath nameUrl_;
    private String idUrl;
    private OlapDocsLabelPath parentPath;
    private boolean readOnly;
    private boolean ghost;
    @Nullable
    private String requireTenantCacheBusting;

    protected OlapDocsEntity() {
    }

    protected OlapDocsEntity(OlapDocsEntityRepositoryType repositoryType) {
        this.repositoryType = repositoryType;
    }

    protected OlapDocsEntity(OlapDocsEntityRepositoryType repositoryType, String uuid, OlapDocsLabelPath parentPath, String caption) {
        this.repositoryType = repositoryType;
        this.uuid = uuid;
        this.parentPath = parentPath;
        this.caption = caption;
    }

    public abstract boolean isLabel();

    public abstract boolean isDoc();

    @Nullable
    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public OlapDocsDocFile getDocFile() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    public OlapDocsLabelPath getParentPath() {
        if (this.parentPath == null) {
            throw new RuntimeException("internal error: label path not setup [uuid:" + String.valueOf(this.getUuid()) + "]!");
        }
        return this.parentPath;
    }

    public void setParentPath(@Nullable OlapDocsLabelPath parentPath) {
        if (parentPath == null) {
            parentPath = new OlapDocsLabelPath();
        }
        this.parentPath = parentPath;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public List<OlapDocsSharing> getSharings() {
        this.assertNotGhost();
        return this.sharings == null ? new ArrayList() : this.sharings;
    }

    public void setSharings(List<OlapDocsSharing> sharings) {
        this.assertNotGhost();
        this.sharings = sharings;
    }

    public void addSharings(List<OlapDocsSharing> sharings) {
        this.assertNotGhost();
        if (this.sharings != null) {
            ArrayList<OlapDocsSharing> sharings_ = new ArrayList<OlapDocsSharing>();
            sharings_.addAll(this.sharings);
            sharings_.addAll(sharings);
            this.sharings = sharings_;
        } else {
            this.sharings = sharings;
        }
    }

    public String getNameUrl() {
        this.assertNotGhost();
        return this.nameUrl;
    }

    public void setNameUrl(String nameUrl) {
        this.assertNotGhost();
        this.nameUrl = nameUrl;
    }

    public OlapPath getNameUrlX() {
        this.assertNotGhost();
        return this.nameUrl_;
    }

    public void setNameUrlX(OlapPath nameUrl) {
        this.assertNotGhost();
        this.nameUrl_ = nameUrl;
    }

    public String getIdUrl() {
        this.assertNotGhost();
        return this.idUrl;
    }

    public void setIdUrl(String idUrl) {
        this.assertNotGhost();
        this.idUrl = idUrl;
    }

    public boolean isReadOnly() {
        return this.isWebPub() || this.readOnly || this.ghost;
    }

    public void setReadOnly(boolean readOnly) {
        if (!readOnly && this.isGhost()) {
            throw new CdProgrammingException("internal error: a ghost cannot be read/write");
        }
        this.readOnly = readOnly;
    }

    public boolean isWebPub() {
        return this.repositoryType == OlapDocsEntityRepositoryType.WEB_PUB;
    }

    public boolean isFileSystem() {
        return this.repositoryType == OlapDocsEntityRepositoryType.FILE_SYSTEM;
    }

    public boolean isGhost() {
        return this.ghost;
    }

    public void setGhost(boolean value) {
        this.ghost = value;
        if (value) {
            this.setReadOnly(true);
        }
    }

    protected void assertNotGhost() {
        if (this.isGhost()) {
            throw new CdProgrammingException("internal error : accessing a ghost's property!");
        }
    }

    public abstract OlapDocsEntity ghost();

    protected void restoreGhost(OlapDocsEntity ghost) {
        ghost.setGhost(true);
        ghost.setUuid(this.uuid);
        ghost.setCaption(this.caption);
        ghost.setParentPath(this.parentPath);
    }

    public void setRequireTenantCacheBusting(@Nullable String tenant) {
        this.requireTenantCacheBusting = tenant;
    }

    @Nullable
    public String getRequireTenantCacheBusting() {
        return this.requireTenantCacheBusting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapDocsEntity that = (OlapDocsEntity)o;
        return !(this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null);
    }

    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }

    public String toString() {
        return this.caption + " : " + this.uuid;
    }
}

