/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.component;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationApplicationException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.gwt.server.reporting.component.OlapReportHeaderConfiguration;
import crazydev.iccube.gwt.server.reporting.component.OlapReportHeadersConfiguration;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingComponentConfiguration;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingLocation;
import crazydev.iccube.gwt.server.reporting.component.template.OlapReportHtml;
import crazydev.iccube.gwt.server.reporting.component.template.OlapReportHtmlInfo;
import crazydev.iccube.gwt.server.reporting.component.template.origin.OlapReportHtmlDocsOriginMF;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorCode;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDocFile;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntity;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsWebReportingHelper;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.gwt.server.requesthandler.reporting.OlapReportRepositoryRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.server.configuration.IcCubeMimeTypesConfiguration;
import crazydev.iccube.server.http.IcCubeResourceServlet;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.jetbrains.annotations.Nullable;

public class OlapReportingServlet
extends IcCubeResourceServlet {
    private static final long serialVersionUID = 6776208805797573958L;
    private final OlapReportingComponentConfiguration configuration;

    public OlapReportingServlet(OlapReportingComponentConfiguration configuration, @Nullable IcCubeMimeTypesConfiguration mimeTypes) {
        super(OlapLoggers.REQUEST, "[docs]", mimeTypes);
        this.configuration = configuration;
    }

    @Override
    public OlapRequestType getRequestType() {
        return OlapRequestType.DOCS;
    }

    @Override
    protected void doHandleUnsafe(HttpServletRequest request, HttpServletResponse response, IcCubeServerRequestContext requestContext) throws ServletException, IOException {
        try {
            if (!requestContext.isReportServerLicensed()) {
                throw new OlapRoleAuthorizationApplicationException("app.reportDocManagement");
            }
            OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
            OlapRoleApplicationPermissions permissions = olapEngineRequestContext.getApplicationPermissions();
            if (!permissions.isReportDashboardReaderEnabled()) {
                permissions.assertReportDocManagementReaderEnabled();
            }
            this.doHandle(request, response, requestContext);
        }
        catch (OlapRoleAuthorizationException | OlapRoleAuthorizationRuntimeException ex) {
            this.logger.error((Object)"%s unexpected request error".formatted(this.logPrefix), ex);
            this.replyException(request, response, requestContext, (Exception)ex);
        }
    }

    @Nullable
    protected String getPathInfo(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String prefix = request.getServletPath();
        if (uri.length() < prefix.length()) {
            return null;
        }
        String pathInfo = uri.substring(prefix.length());
        if (pathInfo.length() == 0) {
            return null;
        }
        int pos = pathInfo.indexOf("?");
        if (pos > -1) {
            return pathInfo.substring(0, pos);
        }
        return pathInfo;
    }

    protected void doHandle(HttpServletRequest httpRequest, HttpServletResponse httpResponse, IcCubeServerRequestContext requestContext) throws ServletException, IOException, OlapRoleAuthorizationException {
        Boolean wmf;
        String servletPath = httpRequest.getServletPath();
        String resourcePathInfo = this.getPathInfo(httpRequest);
        OlapReportHtmlInfo templateInfo = OlapDocsWebReportingHelper.isReportPathInfo(servletPath, resourcePathInfo);
        if (OlapLoggers.DOC_REQUEST.isDebugEnabled()) {
            OlapLoggers.DOC_REQUEST.debug((Object)("[docs] request doc ServletPath: " + servletPath + " ResourcePathInfo: " + resourcePathInfo + (String)(templateInfo != null ? " TemplateInfo:" + templateInfo.isMF() : " TemplateInfo:null")));
        }
        if (templateInfo != null) {
            wmf = templateInfo.isMF();
        } else if (resourcePathInfo != null) {
            if (servletPath.equals("/icCube/report")) {
                if (resourcePathInfo.equals("/")) {
                    String requestURI = httpRequest.getRequestURI();
                    String redirectURL = httpResponse.encodeRedirectURL(URIUtil.addPaths((String)requestURI, (String)"console"));
                    if (OlapLoggers.DOC_REQUEST.isDebugEnabled()) {
                        OlapLoggers.DOC_REQUEST.debug((Object)("[docs] request doc RedirectURL : " + redirectURL));
                    }
                    httpResponse.sendRedirect(redirectURL);
                    return;
                }
                if (!resourcePathInfo.startsWith("/ic3-reporting")) {
                    String redirectURL = httpResponse.encodeRedirectURL(URIUtil.addPaths((String)servletPath, (String)URIUtil.addPaths((String)"/ic3-reporting", (String)resourcePathInfo)));
                    if (OlapLoggers.DOC_REQUEST.isDebugEnabled()) {
                        OlapLoggers.DOC_REQUEST.debug((Object)("[docs] request doc ForwardURL : " + redirectURL));
                    }
                    String servletCanPath = new File(servletPath).getCanonicalPath();
                    String redirectUrlCanPath = new File(redirectURL).getCanonicalPath();
                    if (!redirectUrlCanPath.startsWith(servletCanPath)) {
                        if (OlapLoggers.DOC_REQUEST.isDebugEnabled()) {
                            OlapLoggers.DOC_REQUEST.debug((Object)("[docs] request doc : " + resourcePathInfo + " NOT FOUND [" + servletCanPath + "][" + redirectUrlCanPath + "]"));
                        }
                        this.replyNotFound(httpRequest, httpResponse, requestContext, resourcePathInfo);
                        return;
                    }
                    RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(redirectURL);
                    dispatcher.forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                    return;
                }
                wmf = true;
            } else {
                wmf = false;
            }
        } else {
            wmf = null;
        }
        OlapDocsActualRepository repository = requestContext.getSessionContext().getDocsRepository(requestContext.asRuntimeContext());
        OlapReportRepositoryRequestContext repReqCtxt = new OlapReportRepositoryRequestContext(requestContext, null, wmf);
        if (templateInfo != null) {
            if (templateInfo.isMF()) {
                this.handleReportMF(httpRequest, httpResponse, requestContext, templateInfo);
            }
            return;
        }
        OlapDocsEntity entity = null;
        if (resourcePathInfo != null) {
            try {
                entity = repository.retrieveEntityByUrl(repReqCtxt, resourcePathInfo);
                if (OlapLoggers.DOC_REQUEST.isDebugEnabled()) {
                    OlapLoggers.DOC_REQUEST.debug((Object)("[docs] request doc ResourcePathInfo: " + resourcePathInfo + " entity : " + (entity != null ? "found" : "not-found")));
                }
            }
            catch (OlapDocsErrorException ex) {
                this.replyException(httpRequest, httpResponse, requestContext, (Exception)((Object)ex));
                return;
            }
        }
        if (resourcePathInfo == null || resourcePathInfo.equals("/") || entity != null && entity.isLabel()) {
            if (OlapLoggers.DOC_REQUEST.isDebugEnabled()) {
                OlapLoggers.DOC_REQUEST.debug((Object)("[docs] request doc Redirect check for ResourcePathInfo: " + resourcePathInfo));
            }
            if (resourcePathInfo == null || !httpRequest.getPathInfo().endsWith("/")) {
                String redirect = httpResponse.encodeRedirectURL(URIUtil.addPaths((String)httpRequest.getRequestURI(), (String)"/"));
                if (OlapLoggers.DOC_REQUEST.isDebugEnabled()) {
                    OlapLoggers.DOC_REQUEST.debug((Object)("[docs] request doc Redirect ResourcePathInfo: " + resourcePathInfo + " to: " + redirect));
                }
                httpResponse.sendRedirect(redirect);
                return;
            }
            try {
                String indexHtml = resourcePathInfo + "index.html";
                entity = repository.retrieveEntityByUrl(repReqCtxt, indexHtml);
            }
            catch (OlapDocsErrorException olapDocsErrorException) {
                // empty catch block
            }
        }
        if (entity != null && entity.isDoc()) {
            if (OlapLoggers.DOC_REQUEST.isDebugEnabled()) {
                OlapLoggers.DOC_REQUEST.debug((Object)("[docs] request doc : " + resourcePathInfo + " replying"));
            }
            this.replyDocFromRepository(httpRequest, httpResponse, requestContext, entity);
            return;
        }
        if (OlapLoggers.DOC_REQUEST.isDebugEnabled()) {
            OlapLoggers.DOC_REQUEST.debug((Object)("[docs] request doc : " + resourcePathInfo + " NOT FOUND"));
        }
        this.replyNotFound(httpRequest, httpResponse, requestContext, resourcePathInfo);
    }

    private void replyDocFromRepository(HttpServletRequest httpRequest, HttpServletResponse httpResponse, IcCubeServerRequestContext requestContext, OlapDocsEntity entity) throws IOException {
        try {
            InputStream in;
            OlapDocsDocFile doc;
            block8: {
                doc = entity.getDocFile();
                doc.performRequireTenantCacheBusting(entity);
                in = null;
                try {
                    httpResponse.setCharacterEncoding(doc.getEncoding());
                    httpResponse.setContentType(doc.getMimeType());
                    OlapReportHeadersConfiguration appHeaders = this.configuration.getAppHeaders();
                    List<OlapReportHeaderConfiguration> headers = appHeaders.getHeaders();
                    for (OlapReportHeaderConfiguration header : headers) {
                        String name = header.getName();
                        String value = header.getValue();
                        httpResponse.setHeader(name, value);
                    }
                    in = doc.getInputStream();
                    ServletOutputStream outputStream = httpResponse.getOutputStream();
                    if (OlapLoggers.DOC_REQUEST.isDebugEnabled()) {
                        OlapLoggers.DOC_REQUEST.debug((Object)("[docs] request doc (copy started) : " + doc.getFileName()));
                    }
                    IO.copy((InputStream)in, (OutputStream)outputStream);
                    outputStream.flush();
                    if (!OlapLoggers.DOC_REQUEST.isDebugEnabled()) break block8;
                    OlapLoggers.DOC_REQUEST.debug((Object)("[docs] request doc (copy completed) : " + doc.getFileName()));
                }
                catch (IOException ex) {
                    try {
                        OlapLoggers.DOC_REQUEST.error((Object)"[docs] request unexpected IO exception", (Throwable)ex);
                        throw new OlapDocsErrorException(ex, OlapDocsErrorCode.DOC_FILE_IO_ERROR, new Serializable[]{doc.getFileName(), ex});
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        doc.dispose();
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            doc.dispose();
        }
        catch (OlapDocsErrorException ex) {
            this.replyException(httpRequest, httpResponse, requestContext, (Exception)((Object)ex));
        }
    }

    private void handleReportMF(HttpServletRequest httpRequest, HttpServletResponse httpResponse, IcCubeServerRequestContext requestContext, OlapReportHtmlInfo templateInfo) throws IOException, OlapRoleAuthorizationException {
        if (!templateInfo.isMF()) {
            throw new RuntimeException("internal error: unexpected reporting");
        }
        boolean help = templateInfo.isHelp();
        String requestURI = httpRequest.getRequestURI();
        String queryString = httpRequest.getQueryString();
        if (OlapLoggers.DOC_REQUEST.isDebugEnabled()) {
            OlapLoggers.DOC_REQUEST.debug((Object)("[docs] request report : [uri:" + requestURI + "][queryString:" + queryString + "] [help:" + help + "]"));
        }
        OlapRoleApplicationPermissions perms = requestContext.getOlapEngineRequestContext().getApplicationPermissions();
        perms.assertReportDashboardReaderEnabled();
        OlapReportingLocation location = this.configuration.getLocation();
        OlapReportHtml reportHtml = (switch (location) {
            case OlapReportingLocation.DOCS -> new OlapReportHtmlDocsOriginMF(this.configuration);
            default -> throw new RuntimeException("internal error: unexpected reporting (MF) deployment [" + String.valueOf((Object)location) + "]");
        }).createHtml(requestContext, templateInfo);
        if (reportHtml == null) {
            this.replyNotFound(httpRequest, httpResponse, requestContext, httpRequest.getPathInfo());
            return;
        }
        this.replyReportTemplateMF(httpRequest, httpResponse, reportHtml);
    }

    private void replyReportTemplateMF(HttpServletRequest httpRequest, HttpServletResponse httpResponse, OlapReportHtml reportHtml) throws IOException {
        httpResponse.setCharacterEncoding("UTF-8");
        httpResponse.setContentType("text/html");
        httpResponse.addHeader(HttpHeader.CACHE_CONTROL.asString(), "must-revalidate,no-cache,no-store");
        OlapReportHeadersConfiguration appHeaders = this.configuration.getAppHeaders();
        List<OlapReportHeaderConfiguration> headers = appHeaders.getHeaders();
        for (OlapReportHeaderConfiguration header : headers) {
            String name = header.getName();
            if (HttpHeader.CACHE_CONTROL.asString().equalsIgnoreCase(name)) continue;
            String value = header.getValue();
            httpResponse.setHeader(name, value);
        }
        ServletOutputStream out = httpResponse.getOutputStream();
        String csrfToken = this.getCSRFToken(httpRequest);
        boolean isMdxConsole = OlapReportingServlet.isMdxConsole(httpRequest);
        reportHtml.createHtmlMF(out, csrfToken, isMdxConsole);
    }

    private static boolean isMdxConsole(HttpServletRequest httpRequest) {
        String requestURI = httpRequest.getRequestURI();
        return requestURI != null && requestURI.equals("/icCube/report/mdxConsole");
    }
}

