/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.component;

import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.iccube.gwt.server.reporting.component.OlapReportHeaderConfiguration;
import crazydev.iccube.gwt.server.reporting.component.OlapReportHeadersConfiguration;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingComponentConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.configuration.IcCubeMimeTypesConfiguration;
import crazydev.iccube.server.http.IcCubeResourceServlet;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.IO;
import org.jetbrains.annotations.Nullable;

public class OlapHelpServlet
extends IcCubeResourceServlet {
    private static final long serialVersionUID = -719655617543201558L;
    private final OlapReportingComponentConfiguration configuration;
    private final File helpPathS;
    private final File helpPathD;

    public OlapHelpServlet(OlapRuntime runtime, File tmpDirectory, File docsRepository, OlapReportingComponentConfiguration configuration, @Nullable IcCubeMimeTypesConfiguration mimeTypes) {
        super(OlapLoggers.UX_REQUEST, "[help]", mimeTypes);
        this.configuration = configuration;
        this.helpPathS = runtime.getInstallHelpDirectory();
        this.helpPathD = new File(docsRepository, "ic3-reporting/app");
    }

    public String getEntryPoint() {
        return "/icCube/help/*";
    }

    @Override
    public OlapRequestType getRequestType() {
        return OlapRequestType.HELP;
    }

    @Override
    protected void doHandleUnsafe(HttpServletRequest request, HttpServletResponse response, IcCubeServerRequestContext requestContext) throws ServletException, IOException {
        String servletPath = request.getServletPath();
        String uri = request.getRequestURI();
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty()) {
            RequestDispatcher dispatcher = request.getRequestDispatcher("/icCube/help/index.html");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (pathInfo.equals("/")) {
            response.sendRedirect(response.encodeRedirectURL("/icCube/help"));
            return;
        }
        File rsc = this.getEntity(pathInfo);
        if (rsc != null) {
            if ("/index.html".equals(pathInfo)) {
                this.replyIndexHtml(request, response, rsc);
            } else {
                this.replyResource(request, response, rsc);
            }
            return;
        }
        this.replyNotFound(request, response, requestContext, pathInfo);
    }

    private File getEntity(String pathInfo) {
        File rsc;
        File file = rsc = !this.isDashboardsContent(pathInfo) ? new File(this.helpPathS, pathInfo) : new File(this.helpPathD, pathInfo);
        if (!rsc.exists() || !rsc.isFile()) {
            return null;
        }
        return rsc;
    }

    private boolean isDashboardsContent(String path) {
        if (path.startsWith("/doc")) {
            return !path.endsWith("toc-server.json5") && !path.contains("/server/");
        }
        return false;
    }

    private void replyIndexHtml(HttpServletRequest request, HttpServletResponse response, File resource) throws IOException {
        response.addHeader(HttpHeader.CACHE_CONTROL.asString(), "must-revalidate,no-cache,no-store");
        OlapReportHeadersConfiguration appHeaders = this.configuration.getAppHeaders();
        List<OlapReportHeaderConfiguration> headers = appHeaders.getHeaders();
        for (OlapReportHeaderConfiguration header : headers) {
            String name = header.getName();
            if (HttpHeader.CACHE_CONTROL.asString().equalsIgnoreCase(name)) continue;
            String value = header.getValue();
            response.setHeader(name, value);
        }
        this.sendResource(request, response, resource, false);
    }

    private void replyResource(HttpServletRequest request, HttpServletResponse response, File resource) throws IOException {
        OlapReportHeadersConfiguration appHeaders = this.configuration.getAppHeaders();
        List<OlapReportHeaderConfiguration> headers = appHeaders.getHeaders();
        for (OlapReportHeaderConfiguration header : headers) {
            String name = header.getName();
            String value = header.getValue();
            response.setHeader(name, value);
        }
        this.sendResource(request, response, resource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResource(HttpServletRequest request, HttpServletResponse response, File resource, boolean delete) throws IOException {
        this.setContentType(response, resource);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(resource));){
            ServletOutputStream outputStream = response.getOutputStream();
            IO.copy((InputStream)in, (OutputStream)outputStream);
            outputStream.flush();
        }
        finally {
            if (delete) {
                CdVFileSystemUtils.deleteQuietly((File)resource);
            }
        }
    }
}

