/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.lazytree;

import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreeNodeIdentifier;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreeNodeModel;
import crazydev.iccube.gwt.server.lazytree.LazyTreeChildrenStruct;
import crazydev.iccube.gwt.server.lazytree.LazyTreeVisitor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLazyTreeVisitor<NODE extends GwtLazyTreeNodeModel>
implements LazyTreeVisitor<NODE> {
    private final GwtLazyTreeNodeIdentifier lookupNodeId;
    private final LazyTreeChildrenStruct<NODE> lookupRes;
    private final int fromChildPos;
    private final int childMaxSize;
    protected boolean accept = true;

    public AbstractLazyTreeVisitor(GwtLazyTreeNodeIdentifier lookupNodeId, LazyTreeChildrenStruct<NODE> lookupRes, int fromChildPos, int childMaxSize) {
        this.lookupNodeId = lookupNodeId;
        this.lookupRes = lookupRes;
        this.fromChildPos = fromChildPos;
        this.childMaxSize = childMaxSize;
    }

    @Override
    public boolean isEmpty() {
        return this.lookupRes == null || this.lookupRes.node == null || this.lookupRes.children.isEmpty();
    }

    @Override
    public boolean acceptNode(@Nullable NODE parent, NODE child, int pos, boolean forceAccept) {
        this.handlePath(parent, child);
        if (!this.accept && this.lookupRes.node != parent) {
            return false;
        }
        if (!this.isInBranch(this.lookupNodeId, child) || !this.isInBranch(this.lookupNodeId, parent)) {
            return false;
        }
        if (this.lookupRes.node != null) {
            if (this.lookupRes.node == parent) {
                this.addChild(child, pos);
            }
            this.accept = forceAccept;
        } else if (parent != null && this.lookupNodeId.equals(parent.getNodeId())) {
            this.lookupRes.node = parent;
            this.addChild(child, pos);
            this.accept = forceAccept;
        }
        return this.accept;
    }

    protected void addChild(NODE child, int pos) {
        if (this.fromChildPos != -1 && pos <= this.fromChildPos) {
            return;
        }
        int childrenCount = this.lookupRes.children.size();
        int childMaxSize = this.getMaxForChild(child);
        if (childMaxSize == 0 || childrenCount < childMaxSize) {
            this.lookupRes.children.add(child);
        } else if (childrenCount == childMaxSize) {
            this.lookupRes.children.add(this.getMoreChildren());
        }
    }

    protected int getMaxForChild(NODE child) {
        return this.childMaxSize;
    }

    protected abstract NODE getMoreChildren();

    protected boolean isInBranch(GwtLazyTreeNodeIdentifier lookupNodeId, NODE parent) {
        return false;
    }

    protected void handlePath(NODE parent, NODE child) {
    }
}

