/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.embedded.checker;

import crazydev.common.exception.CdFatalErrorHandler;
import crazydev.iccube.olap.loggers.OlapLoggers;

public class RamUsageChecker
implements Runnable {
    private final CdFatalErrorHandler fatalErrorHandler;
    private final int limit;

    public RamUsageChecker(CdFatalErrorHandler fatalErrorHandler, int limit) {
        this.fatalErrorHandler = fatalErrorHandler;
        this.limit = limit;
    }

    @Override
    public void run() {
        long freeMemory;
        long maxAmount = (long)this.limit * 1024L * 1024L;
        long totalMemory = Runtime.getRuntime().totalMemory();
        long usedMemory = totalMemory - (freeMemory = Runtime.getRuntime().freeMemory());
        if (usedMemory > maxAmount) {
            OlapLoggers.GENERAL.error((Object)("authorized memory usage exceeded [" + usedMemory + "/" + maxAmount + "]"));
            this.fatalErrorHandler.handle("authorized memory usage exceeded", -1);
        }
    }
}

