/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.embedded.checker;

import crazydev.common.exception.CdFatalErrorHandler;
import crazydev.iccube.de.schlichtherle.util.ObfuscatedString;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.embedded.IcCubeExpiryDateNotification;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.info.OlapLixVerifier;
import crazydev.iccube.notification.IOlapNotificationListener;
import crazydev.iccube.notification.OlapNotificationService;
import java.util.Date;
import java.util.Objects;

public class ExpiryDateChecker
implements Runnable {
    private final CdFatalErrorHandler fatalErrorHandler;
    private final OlapLixContent lixContent;
    private final OlapNotificationService notificationService;

    public ExpiryDateChecker(CdFatalErrorHandler fatalErrorHandler, OlapLixContent lixContent, OlapNotificationService notificationService) {
        this.fatalErrorHandler = fatalErrorHandler;
        this.lixContent = lixContent;
        this.notificationService = notificationService;
    }

    @Override
    public void run() {
        this.notifyExpiry();
        this.assertExpiry();
    }

    private void notifyExpiry() {
        IcCubeEngine.expiredUI = null;
        IcCubeEngine.expiryUI = null;
        try {
            Date expiryDate = this.lixContent.getNotAfter();
            if (expiryDate == null) {
                return;
            }
            int remaining = OlapLixContent.getRemainingDays((Date)expiryDate);
            if (remaining <= 0) {
                IcCubeEngine.expiredUI = expiryDate;
            } else if (this.lixContent.isEvaluationLicense()) {
                if (remaining <= 7) {
                    IcCubeEngine.expiryUI = expiryDate;
                }
            } else if (remaining <= 30) {
                IcCubeEngine.expiryUI = expiryDate;
            }
            if (remaining <= 0) {
                return;
            }
            final IcCubeExpiryDateNotification notification = IcCubeEngine.expiryDateNotification;
            if (notification == null) {
                return;
            }
            if (remaining <= 1 && !notification.notified1) {
                this.notificationService.onLicenseExpiryWarning(new IOlapNotificationListener(){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    public void onNotified() {
                        notification.notified30 = true;
                        notification.notified7 = true;
                        notification.notified1 = true;
                    }

                    public void onFinally() {
                    }
                }, expiryDate);
            } else if (remaining <= 7 && !notification.notified7) {
                this.notificationService.onLicenseExpiryWarning(new IOlapNotificationListener(){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    public void onNotified() {
                        notification.notified30 = true;
                        notification.notified7 = true;
                    }

                    public void onFinally() {
                    }
                }, expiryDate);
            } else if (remaining <= 30 && !notification.notified30) {
                this.notificationService.onLicenseExpiryWarning(new IOlapNotificationListener(){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    public void onNotified() {
                        notification.notified30 = true;
                    }

                    public void onFinally() {
                    }
                }, expiryDate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void assertExpiry() {
        try {
            OlapLixVerifier.verifyExpiryDate((CdFatalErrorHandler)this.fatalErrorHandler, (OlapLixContent)this.lixContent);
        }
        catch (Exception ex) {
            this.fatalErrorHandler.handle(new ObfuscatedString(new long[]{3197561416441482040L, -3890094734801402401L, -982492658566057926L}).toString(), -2);
        }
    }
}

