/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.embedded;

import crazydev.common.security.CdPasswordHash;
import crazydev.common.utils.CdOperatingSystemUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdSystemUtils;
import crazydev.common.version.CdVersion;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.version.IcCubeServerVersion;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.Nullable;

public class IcCubeEnginePingHelper {
    static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public static void ping(final String ping, final int magicNumber, final @Nullable String licType, final @Nullable String licHolder, final @Nullable IcCubeRequestStatusManager requestManager) {
        if (OlapLixContent.pingOff.equals(ping)) {
            return;
        }
        final int[] daysActive = new int[]{0};
        scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (daysActive[0] > 0) {
                        CdPasswordHash.reSeed();
                    }
                    long gwtRequestCount = requestManager != null ? requestManager.getGwtRequestCount() : -1L;
                    long gviRequestCount = requestManager != null ? requestManager.getGviRequestCount() : -1L;
                    long xmlaRequestCount = requestManager != null ? requestManager.getXmlaRequestCount() : -1L;
                    long otherRequestCount = requestManager != null ? requestManager.getOtherRequestCount() : -1L;
                    IcCubeEnginePingHelper.doPing(ping, licType, licHolder, daysActive[0], magicNumber, gwtRequestCount, gviRequestCount, xmlaRequestCount, otherRequestCount);
                    daysActive[0] = daysActive[0] + 1;
                }
                catch (Throwable ignored) {
                    OlapLoggers.SERVER.error((Object)"Unexpected Error", ignored);
                }
            }
        }, 0L, 1L, TimeUnit.DAYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doPing(String ping, @Nullable String licType, @Nullable String licHolder, int daysActive, int magicNumber, long gwtRequestCount, long gviRequestCount, long xmlaRequestCount, long otherRequestCount) throws IOException, URISyntaxException {
        OlapLoggers.SERVER.info((Object)"Pinging...");
        URI uri = new URIBuilder().setScheme("http").setHost("license1.icCube.com").setPath("/license-ping.php").build();
        ArrayList<BasicNameValuePair> values = new ArrayList<BasicNameValuePair>();
        CdVersion version = IcCubeServerVersion.get();
        String versionAsString = version.asString();
        values.add(new BasicNameValuePair("version", IcCubeEnginePingHelper.escape(versionAsString)));
        values.add(new BasicNameValuePair("days", "" + daysActive));
        values.add(new BasicNameValuePair("licType", CdStringUtils.isNullOrBlank((String)licType) ? "n/a" : IcCubeEnginePingHelper.escape(licType)));
        values.add(new BasicNameValuePair("licHolder", CdStringUtils.isNullOrBlank((String)licHolder) ? "n/a" : IcCubeEnginePingHelper.escape(licHolder)));
        values.add(new BasicNameValuePair("os", IcCubeEnginePingHelper.getOsName()));
        values.add(new BasicNameValuePair("arch", IcCubeEnginePingHelper.getOsArch()));
        values.add(new BasicNameValuePair("cpu", IcCubeEnginePingHelper.getProcessors()));
        values.add(new BasicNameValuePair("memory", IcCubeEnginePingHelper.getTotalPhysicalMemorySize()));
        values.add(new BasicNameValuePair("jvmVendor", IcCubeEnginePingHelper.escape(System.getProperty("java.vm.vendor"))));
        values.add(new BasicNameValuePair("jvmName", IcCubeEnginePingHelper.escape(System.getProperty("java.vm.name"))));
        values.add(new BasicNameValuePair("magicNumber", "" + magicNumber));
        values.add(new BasicNameValuePair("gwtRequest", "" + gwtRequestCount));
        values.add(new BasicNameValuePair("gviRequest", "" + gviRequestCount));
        values.add(new BasicNameValuePair("xmlaRequest", "" + xmlaRequestCount));
        values.add(new BasicNameValuePair("otherRequest", "" + otherRequestCount));
        List<String> addresses = IcCubeEnginePingHelper.getMacAddresses();
        for (int idx = 0; idx < addresses.size(); ++idx) {
            String address = addresses.get(idx);
            values.add(new BasicNameValuePair("mac" + idx, address));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(values, "UTF-8");
        HttpPost request = new HttpPost(uri);
        request.setEntity((HttpEntity)entity);
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
            HttpEntity responseEntity = response.getEntity();
            EntityUtils.consume((HttpEntity)responseEntity);
        }
    }

    private static String escape(@Nullable String value) {
        if (value == null) {
            return "n/a";
        }
        String escaped = value.replaceAll(",", "-");
        return escaped;
    }

    private static String getOsName() {
        return CdOperatingSystemUtils.getName();
    }

    private static String getOsArch() {
        return CdOperatingSystemUtils.getArch();
    }

    private static String getProcessors() {
        return "" + CdSystemUtils.availableProcessors();
    }

    private static String getTotalPhysicalMemorySize() {
        return "" + CdOperatingSystemUtils.getTotalPhysicalMemorySize();
    }

    private static List<String> getMacAddresses() throws SocketException {
        ArrayList<String> addresses = new ArrayList<String>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        if (networkInterfaces != null) {
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                String name = networkInterface.getName();
                byte[] mac = networkInterface.getHardwareAddress();
                String nameX = name == null ? "n/a" : name;
                String macX = mac == null || mac.length == 0 ? "n/a" : IcCubeEnginePingHelper.formatMacAddress(mac);
                String address = macX + " - " + nameX;
                addresses.add(address);
            }
        }
        return addresses;
    }

    private static String formatMacAddress(byte[] mac) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
        }
        return sb.toString();
    }
}

