/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.embedded;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdLog4jUtils;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.master.backup.save.M_BackupManagerContainer;
import crazydev.iccube.cluster.shared.backup.S_RestoreMode;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.gwt.base.shared.comm.request.GwtQuery;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtAbstractLoadSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtLoadSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtRestoreSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLifeCycleReply;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLoadStatus;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.tenants.OlapTenantDefinition;
import crazydev.iccube.tenants.OlapTenantManager;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeEngineHelper {
    public static void configureLog4J(OlapDirectories directories, File log4JXmlFile) throws IOException {
        String icCubeLogDirectory = IcCubeEngineHelper.getLogDirectoryValue();
        if (icCubeLogDirectory == null) {
            File applicationDirectory = directories.getDataDirectory__();
            File logDirectory = new File(applicationDirectory, "log");
            CdVFileSystem vfs = directories.getVfs();
            vfs.validateDirectoryOnStartup(new File(applicationDirectory, "log"));
            icCubeLogDirectory = logDirectory.getAbsolutePath();
            System.setProperty("icCube.logDirectory", icCubeLogDirectory);
        }
        CdLog4jUtils.configure((String)log4JXmlFile.getAbsolutePath());
    }

    public static String getLogDirectoryValue() {
        return System.getProperty("icCube.logDirectory");
    }

    @Nullable
    public static File getLogDirectory() {
        String value = IcCubeEngineHelper.getLogDirectoryValue();
        File file = new File(value);
        return file.isDirectory() ? file : null;
    }

    public static void setUpLoadOnStartupSchemas(final IcCubeEngine icCubeEngine, final OlapEngineComponent olapEngine) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                IcCubeEngineHelper.performSetupLoadOnStartupSchemas(icCubeEngine, olapEngine);
            }
        }, "load-schema-on-startup").start();
    }

    private static void performSetupLoadOnStartupSchemas(IcCubeEngine icCubeEngine, OlapEngineComponent olapEngine) {
        OlapLoggers.CHECKPOINTS.info((Object)"[ic3] load on startup schemas");
        OlapEngineApplicationContext appContext = icCubeEngine.getOlapEngineApplicationContext();
        OlapRuntimeContext runtimeContext = OlapRuntimeContext.create((OlapEngineApplicationContext)appContext);
        IcCubeEngineHelper.doPerformSetupLoadOnStartupSchemas(icCubeEngine, olapEngine, runtimeContext);
        if (appContext.isWithMultiTenant()) {
            OlapTenantManager tenants = icCubeEngine.getTenantManager();
            for (OlapTenantDefinition tenantDefinition : tenants.getTenantDefinitions()) {
                OlapTenant tenant = new OlapTenant(tenantDefinition.getName(), tenantDefinition.getDirectory());
                OlapRuntimeContext runtimeContext2 = OlapRuntimeContext.create((OlapEngineApplicationContext)appContext, (OlapTenant)tenant);
                IcCubeEngineHelper.doPerformSetupLoadOnStartupSchemas(icCubeEngine, olapEngine, runtimeContext2);
            }
        }
    }

    private static void doPerformSetupLoadOnStartupSchemas(IcCubeEngine icCubeEngine, OlapEngineComponent olapEngine, OlapRuntimeContext runtimeContext) {
        OlapTenant tenant = runtimeContext.getTenant();
        String tenantInfo = OlapTenant.info((OlapTenant)runtimeContext.getTenant());
        try {
            OlapLoggers.SCHEMA.info((Object)("[startup]" + tenantInfo + " loading all schemas"));
            olapEngine.foreachSchemaFactoryInfo(runtimeContext, info -> {
                if (info != null && info.isLoadOnStartup()) {
                    File factoryFile = info.getFile();
                    String factoryShortFileName = factoryFile.getName();
                    String factoryFileAbsolutePath = factoryFile.getAbsolutePath();
                    String schemaName = info.getName();
                    try {
                        GwtAbstractLoadSchemaQuery gwtQuery;
                        M_BackupManagerContainer backups = icCubeEngine.getBackupManager();
                        M_BackupManager backupManager = backups.getOrCreateBackupManager(runtimeContext);
                        String timestamp = backupManager.getLatestValidBackup(schemaName);
                        if (timestamp != null) {
                            OlapLoggers.SCHEMA.info((Object)("[startup]" + tenantInfo + " restoring schema [" + schemaName + "] from backup [" + timestamp + "]"));
                            OlapLoggers.CHECKPOINTS.info((Object)"[ic3] restoring schema [%s] from backup [%s] [tenant:%s]".formatted(schemaName, timestamp, tenantInfo));
                            gwtQuery = new GwtRestoreSchemaQuery(factoryShortFileName, factoryFileAbsolutePath, info.getName(), timestamp, S_RestoreMode.FULL.name());
                        } else {
                            OlapLoggers.SCHEMA.info((Object)("[startup]" + tenantInfo + " loading schema [" + factoryFileAbsolutePath + "]"));
                            OlapLoggers.CHECKPOINTS.info((Object)"[ic3] loading schema [%s] [tenant:%s]".formatted(factoryFileAbsolutePath, tenantInfo));
                            gwtQuery = new GwtLoadSchemaQuery(factoryShortFileName, factoryFileAbsolutePath);
                        }
                        GwtInfo response = icCubeEngine.submitAndWaitGwtRequestEx((GwtQuery)gwtQuery, tenant);
                        GwtSchemaLifeCycleReply reply = (GwtSchemaLifeCycleReply)response;
                        GwtSchemaLoadStatus status = reply.getStatus();
                        if (status != GwtSchemaLoadStatus.LOADED) {
                            OlapLoggers.SCHEMA.error((Object)("[startup]" + tenantInfo + " schema [" + factoryShortFileName + "] not loaded [" + String.valueOf((Object)status) + "]"));
                        }
                    }
                    catch (Exception ex) {
                        OlapLoggers.SCHEMA.error((Object)("[startup]" + tenantInfo + " schema [" + factoryShortFileName + "] not loaded because of unexpected error."), (Throwable)ex);
                    }
                }
                return true;
            });
            OlapLoggers.SCHEMA.info((Object)("[startup]" + tenantInfo + " loading all schemas done"));
        }
        catch (Exception ex) {
            OlapLoggers.SCHEMA.warn((Object)("[startup]" + tenantInfo + " load all schemas unexpected error"), (Throwable)ex);
        }
    }
}

