/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.embedded;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.revision.CdVFileRevHelperConf;
import crazydev.common.fs.revision.CdVFileRevManagerKind;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.directories.OlapDirectoriesConfiguration;
import crazydev.iccube.directories.impl.OlapBuilderDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapWebPubDirectoryConfiguration;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.schemas.OlapEngineFileSystemSchemaDefFactoryHelper;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import java.io.File;
import java.io.IOException;

public abstract class IcCubeEngineDirectoryHelper {
    public static void setUpWebPubDirectory(OlapRuntime runtime, IcCubeServerConfiguration configuration) {
        OlapDirectoriesConfiguration directories = configuration.getDirectories();
        OlapWebPubDirectoryConfiguration webPub = directories.getWebPubDirectory();
        if (webPub.wasCreated()) {
            runtime.setUpWebPubDirectory(webPub.asFile());
        }
    }

    public static void setUpTenantsDirectory(OlapRuntime runtime, IcCubeServerConfiguration configuration) {
        runtime.setUpTenantsDirectory(configuration.getDirectories());
    }

    public static void setUpUsersDirectory(OlapRuntime runtime, IcCubeServerConfiguration configuration) {
        runtime.setUpUsersDirectory(configuration.getDirectories());
    }

    public static void setUpRolesDirectory(OlapRuntime runtime, IcCubeServerConfiguration configuration) {
        runtime.setUpRolesDirectory(configuration.getDirectories());
    }

    public static void setUpCubesDirectory(OlapRuntime runtime, IcCubeServerConfiguration configuration) {
        runtime.setUpCubesDirectory(configuration.getDirectories());
    }

    public static void setUpBuilderDirectory(CdVFileSystem vfs, IcCubeServerConfiguration configuration, OlapEngineComponent olapEngineComponent, UxBuilderSchemaService service) {
        OlapDirectoriesConfiguration directoryConfiguration = configuration.getDirectories();
        OlapBuilderDirectoryConfiguration builderDirectoryConfiguration = directoryConfiguration.getBuilderDirectory();
        if (builderDirectoryConfiguration.wasCreated()) {
            File tmpDirectory = directoryConfiguration.getTmpDirectory().asFile();
            File builderDirectory = directoryConfiguration.getBuilderDirectory().asFile();
            File cubesDirectory = directoryConfiguration.getCubesDirectory().asFile();
            File offlineDirectory = directoryConfiguration.getOfflineDirectory().asFile();
            OlapLoggers.SERVER.info((Object)("[directory] /builder directory setup using the content of [" + cubesDirectory.getAbsolutePath() + "]"));
            OlapBuilderMetaInformationRepository builderMetaInfoRepository = olapEngineComponent.getBuilderMetaInformationRepository();
            OlapEngineFileSystemSchemaDefFactoryHelper helper = new OlapEngineFileSystemSchemaDefFactoryHelper(olapEngineComponent.getVfs(), new CdVFileRevHelperConf(CdVFileRevManagerKind.SCHEMA_CUBES, tmpDirectory, cubesDirectory), cubesDirectory, offlineDirectory, builderMetaInfoRepository);
            helper.foreachSchemaFactoryFile(null, file -> {
                try {
                    File path = CdVFileSystem.toRelativePath((File)cubesDirectory, (File)file);
                    File destFile = new File(builderDirectory, path.getName());
                    vfs.copyForDirectoryInitOnStartup(file, destFile);
                }
                catch (IOException ex) {
                    OlapLoggers.GENERAL.warn((Object)("Could not copy the schema [" + file.getName() + "] into the builder directory"), (Throwable)ex);
                }
                return true;
            });
            OlapLoggers.SERVER.info((Object)"/builder refresh cache: started");
            service.refreshCache(false);
            OlapLoggers.SERVER.info((Object)"/builder refresh cache: completed");
        }
    }
}

