/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.embedded;

import crazydev.common.exception.CdException;
import crazydev.common.exception.CdFatalErrorHandler;
import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.builder.executor.pool.OlapBuilderTableExecutorPool;
import crazydev.iccube.cluster.master.backup.save.M_BackupManagerContainer;
import crazydev.iccube.configuration.component.plugins.OlapConfPluginClassProcessor;
import crazydev.iccube.de.schlichtherle.util.ObfuscatedString;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.embedded.IcCubeEngineDirectoryHelper;
import crazydev.iccube.embedded.IcCubeEngineHelper;
import crazydev.iccube.embedded.IcCubeEnginePingHelper;
import crazydev.iccube.embedded.IcCubeEngineUserHelper;
import crazydev.iccube.embedded.IcCubeExpiryDateNotification;
import crazydev.iccube.embedded.IcCubeLocalMasterEngine;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.gwt.base.shared.comm.GwtReply;
import crazydev.iccube.gwt.base.shared.comm.request.GwtQuery;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.plugins.GwtLoadAllPluginsQuery;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.IOlapContextLoggers;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutorsManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.principal.OlapInternalPrincipal;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestInfo;
import crazydev.iccube.request.log.OlapRequestTracker;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.IcCubeServerListener;
import crazydev.iccube.server.bigbrother.counters.IcBigBrotherCounter;
import crazydev.iccube.server.bigbrother.counters.executor.IcBigBrotherMdxTaskQueueSizeCounter;
import crazydev.iccube.server.bigbrother.counters.executor.IcBigBrotherRequestTaskQueueSizeCounter;
import crazydev.iccube.server.bigbrother.counters.executor.IcBigBrotherTableLoadingTaskQueueSizeCounter;
import crazydev.iccube.server.bigbrother.counters.executor.IcBigBrotherTableProcessingTaskQueueSizeCounter;
import crazydev.iccube.server.bigbrother.counters.request.IcBigBrotherTotalLoadRequestCountCounter;
import crazydev.iccube.server.bigbrother.counters.request.IcBigBrotherTotalLoadRequestTimeCounter;
import crazydev.iccube.server.bigbrother.counters.request.IcBigBrotherTotalMdxRequestCountCounter;
import crazydev.iccube.server.bigbrother.counters.request.IcBigBrotherTotalMdxRequestTimeCounter;
import crazydev.iccube.server.bigbrother.counters.request.IcBigBrotherTotalOtherRequestCountCounter;
import crazydev.iccube.server.bigbrother.counters.request.IcBigBrotherTotalOtherRequestTimeCounter;
import crazydev.iccube.server.bigbrother.counters.session.IcBigBrotherHttpSessionCountCounter;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.configuration.IcCubeServerProperties;
import crazydev.iccube.server.configuration.ai.IcCubeAIConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.http.IcCubeHttpComponent;
import crazydev.iccube.server.loggers.OlapLoggerLevelManager;
import crazydev.iccube.server.request.executor.IcCubeServerTaskExecutor;
import crazydev.iccube.server.request.processor.gvi.IcCubeGviRequestProcessor;
import crazydev.iccube.server.request.processor.gwt.IcCubeGwtRequestProcessor;
import crazydev.iccube.server.request.processor.print.IcCubePrintRequestProcessor;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.xmla.IcCubeXmlaRequestProcessor;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequest;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.server.version.IcCubeServerVersion;
import crazydev.iccube.tenants.OlapTenantManager;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.common.model.UxModeTypeRepository;
import crazydev.iccube.ux.processor.UxRequestProcessor;
import crazydev.xmla.server.iccube.server.engine.XmlaServerProxy;
import java.awt.SystemTray;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeEngine {
    @Nullable
    public static volatile IcCubeExpiryDateNotification expiryDateNotification;
    @Nullable
    public static volatile Date expiredUI;
    @Nullable
    public static volatile Date expiryUI;
    protected final OlapRuntime runtime;
    protected final IcCubeServerConfiguration configuration;
    protected final OlapDirectories directories;
    private final CdFatalErrorHandler fatalErrorHandler;
    @Nullable
    private final OlapFileSystem logSystem;
    protected IcCubeServerApplicationContext applicationContext;
    protected OlapEngineApplicationContext olapEngineApplicationContext;

    public IcCubeEngine(CdFatalErrorHandler fatalErrorHandler, Object lix, OlapNotificationService notificationService, OlapRuntime runtime, IcCubeServerConfiguration configuration, OlapDirectories directories, boolean withMultiTenant) {
        OlapLoggers.GENERAL.info((Object)"Creating the icCube Server...");
        OlapLixContent lixContent = (OlapLixContent)lix;
        try {
            if (!lixContent.isServerVersionAvailable(IcCubeServerVersion.get())) {
                OlapLoggers.GENERAL.error((Object)(new ObfuscatedString(new long[]{-2402174678674942310L, -4270542380485830787L, 2051520693141554525L, 4669785332454042126L, 1396249906329762936L}).toString() + String.valueOf(IcCubeServerVersion.get())));
                System.exit(-2);
            }
        }
        catch (RuntimeException unlikely) {
            OlapLoggers.GENERAL.error((Object)(new ObfuscatedString(new long[]{-3611075560756755019L, 5285465689351283483L, -8143556109290795758L, 2881027521273147789L, 362940020336359907L}).toString() + String.valueOf(IcCubeServerVersion.get()) + " : " + unlikely.getMessage()));
            System.exit(-2);
        }
        this.fatalErrorHandler = fatalErrorHandler;
        this.runtime = runtime;
        this.configuration = configuration;
        this.directories = directories;
        File logDirectory = IcCubeEngineHelper.getLogDirectory();
        this.logSystem = logDirectory == null ? null : OlapFileSystem.createLogFileSystem((OlapRuntime)runtime, (File)logDirectory);
        OlapLoggers.GENERAL.debug((Object)"[server] creating the icCube engine");
    }

    public static List<IcBigBrotherCounter> setupBigBrotherCounters(IcCubeRequestStatusManager requestStatusManager, IcCubeServerTaskExecutor taskExecutor, OlapMdxExecutorsManager mdxExecutorsManager, OlapBuilderTableExecutorPool tableExecutorPool, @Nullable IcCubeHttpComponent httpComponent) {
        ArrayList<IcBigBrotherCounter> counters = new ArrayList<IcBigBrotherCounter>();
        counters.add(new IcBigBrotherHttpSessionCountCounter(httpComponent));
        counters.add(new IcBigBrotherTotalLoadRequestCountCounter(requestStatusManager));
        counters.add(new IcBigBrotherTotalLoadRequestTimeCounter(requestStatusManager));
        counters.add(new IcBigBrotherTotalMdxRequestCountCounter(requestStatusManager));
        counters.add(new IcBigBrotherTotalMdxRequestTimeCounter(requestStatusManager));
        counters.add(new IcBigBrotherTotalOtherRequestCountCounter(requestStatusManager));
        counters.add(new IcBigBrotherTotalOtherRequestTimeCounter(requestStatusManager));
        counters.add(new IcBigBrotherRequestTaskQueueSizeCounter(taskExecutor));
        counters.add(new IcBigBrotherMdxTaskQueueSizeCounter(mdxExecutorsManager));
        counters.add(new IcBigBrotherTableLoadingTaskQueueSizeCounter(tableExecutorPool));
        counters.add(new IcBigBrotherTableProcessingTaskQueueSizeCounter(tableExecutorPool));
        return counters;
    }

    public static IcCubeEngine createAndSetup(CdFatalErrorHandler fatalErrorHandler, Object lix, OlapNotificationService notificationService, OlapRuntime runtime, IcCubeServerConfiguration configuration, OlapDirectories directories, boolean withMultiTenant) throws CdException {
        OlapLixContent lixContent = (OlapLixContent)lix;
        if (withMultiTenant) {
            IcCubeEngineDirectoryHelper.setUpTenantsDirectory(runtime, configuration);
        }
        IcCubeEngineDirectoryHelper.setUpUsersDirectory(runtime, configuration);
        IcCubeEngineDirectoryHelper.setUpRolesDirectory(runtime, configuration);
        IcCubeEngineDirectoryHelper.setUpWebPubDirectory(runtime, configuration);
        IcCubeEngineDirectoryHelper.setUpCubesDirectory(runtime, configuration);
        IcCubeEngine.cleanupTmpDirectories(directories);
        IcCubeLocalMasterEngine engine = new IcCubeLocalMasterEngine(fatalErrorHandler, lixContent, notificationService, runtime, configuration, directories, withMultiTenant);
        ((IcCubeEngine)engine).setUpServicesAndComponents();
        if (engine.olapEngineApplicationContext != null) {
            OlapEngineApplicationContext engineAppContext = engine.olapEngineApplicationContext;
            IcCubeServerApplicationContext appContext = engine.getApplicationContext();
            OlapRuntimeContext rContext = OlapRuntimeContext.create((OlapEngineApplicationContext)engineAppContext);
            UxBuilderSchemaService service = appContext.getPersistentSchemaService(rContext);
            IcCubeEngineDirectoryHelper.setUpBuilderDirectory(runtime.getVfs(), configuration, engine.getOlapEngineComponent(), service);
        }
        return engine;
    }

    private static void cleanupTmpDirectories(OlapDirectories directories) {
        CdVFileSystem vfs = directories.getVfs();
        File tmp = directories.getTmpDirectory__();
        OlapLoggers.GENERAL.info((Object)("[startup] cleanup /tmp directory content [" + tmp.getAbsolutePath() + "]"));
        vfs.empty(tmp);
        File schemaData = directories.getSchemaDataDirectory__();
        OlapLoggers.GENERAL.info((Object)("[startup] cleanup /schemaData directory content [" + schemaData.getAbsolutePath() + "]"));
        vfs.empty(schemaData);
    }

    public Locale getLocale() {
        return this.getOlapEngineComponent().getLocale();
    }

    public OlapRuntime getRuntime() {
        return this.runtime;
    }

    public IcCubeServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isFileSystemRootVisibleInDocs() {
        IcCubeServerProperties serverProperties = this.configuration.getProperties();
        return serverProperties.isFileSystemRootVisibleInDocs();
    }

    @Nullable
    public OlapFileSystem getLogRoot() {
        return this.logSystem;
    }

    public OlapDirectories getDirectories__() {
        return this.directories;
    }

    public abstract int getHttpSessionCount();

    public abstract int getXmlaSessionCount();

    public IcCubeServerApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public OlapEngineApplicationContext getOlapEngineApplicationContext() {
        return this.olapEngineApplicationContext;
    }

    public abstract OlapTenantManager getTenantManager();

    @Nullable
    public <T> T getServletContextAttribute(String name) {
        return null;
    }

    public abstract IOlapAuthenticationService getAuthenticationService();

    public abstract void setAuthenticationService(IOlapAuthenticationService var1);

    public IOlapPermissionsService getAuthorizationService() {
        return this.olapEngineApplicationContext.getAuthorizationService();
    }

    @Nullable
    public abstract IcCubePrintService getPrintService();

    public abstract boolean isPrintServiceSetupOnError();

    public OlapNotificationService getNotificationService() {
        return this.olapEngineApplicationContext.getNotificationService();
    }

    public boolean isUxActive() {
        return false;
    }

    public boolean isAuthorizationLicensed() {
        return this.olapEngineApplicationContext.isAccessRightsLicensed();
    }

    public OlapMdxExecutorsManager getMdxExecutorsManager() {
        return this.olapEngineApplicationContext.getMdxExecutorsManager();
    }

    public OlapCacheManager getCacheManager() {
        return this.olapEngineApplicationContext.getCacheManager();
    }

    public abstract IcCubeRequestStatusManager getRequestStatusManager();

    public abstract IcCubeGwtRequestProcessor getGwtRequestProcessor();

    public abstract UxRequestProcessor getUxRequestProcessor();

    public abstract IcCubeGviRequestProcessor getGviRequestProcessor();

    public abstract IcCubePrintRequestProcessor getPrintRequestProcessor();

    public abstract IcCubeXmlaRequestProcessor getXmlaRequestProcessor();

    public abstract XmlaServerProxy getXmlaServerProxy();

    public OlapEngineComponent getOlapEngineComponent() {
        return this.olapEngineApplicationContext.getOlapEngineComponent();
    }

    public abstract IcCubeScheduler getScheduler(IcCubeSchedulerKind var1);

    public abstract M_BackupManagerContainer getBackupManager();

    @Nullable
    public abstract OlapConfPluginClassProcessor createUiModelConverterPluginClassProcessor(boolean var1);

    @Nullable
    public abstract OlapConfPluginClassProcessor createUxModelPluginClassProcessor(boolean var1);

    public abstract UxModeTypeRepository getUxModelTypeRepository();

    public abstract void setUpServicesAndComponents() throws CdException;

    protected void setUpPlugins() {
        try {
            GwtLoadAllPluginsQuery loadAllPlugins = new GwtLoadAllPluginsQuery();
            this.submitAndWaitGwtRequestEx(loadAllPlugins);
        }
        catch (Exception ex) {
            OlapLoggers.GENERAL.warn((Object)"Could not setup the plugins properly!", (Throwable)ex);
        }
    }

    public abstract List<String> getKnownUserNames();

    public abstract void start(@Nullable IcCubeServerListener var1, boolean var2) throws Exception;

    public void setupDocsRepositoryNow() {
        OlapDocsActualRepository repository = this.applicationContext.createReportRepository();
        OlapLoggerLevelManager loggers = this.applicationContext.getLoggerLevelManager();
        loggers.applyOverrides();
    }

    public GwtReply<? extends GwtInfo> submitAndWaitGwtRequest(GwtQuery query) {
        return this.submitAndWaitGwtRequest(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GwtReply<? extends GwtInfo> submitAndWaitGwtRequest(GwtQuery query, @Nullable OlapTenant tenant) {
        OlapRequestId requestId = OlapRequestId.next((OlapRequestType)OlapRequestType.GWT, (String)query.getClientUUID());
        OlapChattyRequest chattyRequest = IcCubeGwtServerRequest.isChattyRequest(query);
        OlapRequestVerbosity verbosity = IcCubeGwtServerRequest.getVerbosity(query);
        OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
        OlapRequestTracker.onInternalSubmitStarted((OlapRequestInfo)requestInfo);
        try {
            IcCubeEngineUserHelper sessionHelper = this.createIcCubeUserSessionContext(null, tenant);
            try {
                IcCubeGwtServerRequest request = new IcCubeGwtServerRequest(requestId, query);
                IcCubeGwtServerRequestContext requestContext = this.createIcCubeUserRequestContext(sessionHelper, request);
                GwtReply<? extends GwtInfo> gwtReply = this.submitAndWaitGwtRequest(request, requestContext);
                sessionHelper.onSessionDestroyed();
                return gwtReply;
            }
            catch (Throwable throwable) {
                sessionHelper.onSessionDestroyed();
                throw throwable;
            }
        }
        finally {
            OlapRequestTracker.onInternalSubmitDone((OlapRequestInfo)requestInfo);
        }
    }

    public GwtInfo submitAndWaitGwtRequestEx(GwtQuery query) {
        return this.submitAndWaitGwtRequestEx(query, (OlapTenant)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GwtInfo submitAndWaitGwtRequestEx(GwtQuery query, @Nullable OlapTenant tenant) {
        IcCubeEngineUserHelper sessionHelper = this.createIcCubeUserSessionContext(null, tenant);
        try {
            GwtInfo gwtInfo = this.submitAndWaitGwtRequestEx(query, sessionHelper);
            return gwtInfo;
        }
        finally {
            sessionHelper.onSessionDestroyed();
        }
    }

    public abstract GwtInfo submitAndWaitGwtRequestEx(GwtQuery var1, IcCubeEngineUserHelper var2);

    public abstract GwtReply<? extends GwtInfo> submitAndWaitGwtRequest(IcCubeGwtServerRequest var1, IcCubeGwtServerRequestContext var2);

    public abstract void fireGwtRequest(GwtQuery var1, IcCubeEngineUserHelper var2);

    public IcCubeEngineUserHelper createIcCubeUserSessionContext(@Nullable IOlapContextLoggers loggers) {
        return this.createIcCubeUserSessionContext(loggers, null);
    }

    public IcCubeEngineUserHelper createIcCubeUserSessionContext(@Nullable IOlapContextLoggers loggers, @Nullable OlapTenant tenant) {
        IOlapPermissionsService authorizationServiceWrapper = this.olapEngineApplicationContext.getAuthorizationService();
        OlapRolePermissions permissions = authorizationServiceWrapper.getAdministratorRolePermissions();
        OlapInternalPrincipal principal = new OlapInternalPrincipal(tenant, "icCube", permissions.getRoleName(), null);
        String sessionId = UUID.randomUUID().toString();
        boolean sessionLess = false;
        OlapEngineSessionContext engineSessionContext = new OlapEngineSessionContext(this.applicationContext.getOlapEngineApplicationContext(), false, sessionId, (OlapPrincipal)principal, loggers);
        IcCubeServerSessionContext sessionContext = new IcCubeServerSessionContext(this.applicationContext, null, sessionId, engineSessionContext);
        return new IcCubeEngineUserHelper((OlapPrincipal)principal, permissions, sessionContext);
    }

    protected IcCubeGwtServerRequestContext createIcCubeUserRequestContext(IcCubeEngineUserHelper sessionHelper, IcCubeGwtServerRequest request) {
        return new IcCubeGwtServerRequestContext(sessionHelper.getSessionContext(), request, sessionHelper.getPermissions());
    }

    public void shutdown() {
        OlapEngineComponent olapEngineComponent;
        OlapMdxExecutorsManager mdxExecutors;
        if (IcCubeEnginePingHelper.scheduler != null) {
            IcCubeEnginePingHelper.scheduler.shutdownNow();
        }
        if ((mdxExecutors = this.olapEngineApplicationContext.getMdxExecutorsManager()) != null) {
            mdxExecutors.shutdownNow();
        }
        if ((olapEngineComponent = this.getOlapEngineComponent()) != null) {
            olapEngineComponent.shutdownNow(true);
        }
        IOlapPermissionsService perms = this.olapEngineApplicationContext.getAuthorizationService();
        perms.shutdownNow();
        this.applicationContext.shutdownReportRepository();
        OlapNotificationService notificationService = this.olapEngineApplicationContext.getNotificationService();
        notificationService.stop();
    }

    public boolean supportSystemTray() {
        try {
            return SystemTray.isSupported();
        }
        catch (Throwable ex) {
            OlapLoggers.SERVER.warn((Object)"[AWT] could not determine the system tray support", ex);
            return false;
        }
    }

    public abstract String getShortName();

    public void onLixChange(File file, OlapLixContent lixContent) {
        OlapLoggers.SERVER.info((Object)"[license] hot deployment");
        if (!lixContent.isPayingLicense()) {
            return;
        }
        OlapLixContent prevLixContent = this.getOlapEngineComponent().getLixContent();
        if (!prevLixContent.isPayingLicense()) {
            return;
        }
        boolean diSomething = false;
        Date prevNotAfter = prevLixContent.getNotAfter();
        Date notAfter = lixContent.getNotAfter();
        if (prevNotAfter == null || notAfter == null) {
            return;
        }
        if (notAfter.compareTo(prevNotAfter) > 0) {
            OlapLoggers.SERVER.info((Object)("[license] upgraded expiry date: " + String.valueOf(notAfter)));
            prevLixContent.reset(OlapLixContent.notAfter, (Object)notAfter);
            expiryDateNotification = new IcCubeExpiryDateNotification();
            expiryUI = null;
            expiredUI = null;
            diSomething = true;
        }
        int prevUserLimit = prevLixContent.getUserLimit();
        int userLimit = lixContent.getUserLimit();
        if (userLimit > prevUserLimit) {
            OlapLoggers.SERVER.info((Object)("[license] upgraded user limit: " + userLimit));
            prevLixContent.reset(OlapLixContent.userLimit, (Object)userLimit);
            diSomething = true;
        }
        int prevMemoryLimit = prevLixContent.getMemoryLimit();
        int memoryLimit = lixContent.getMemoryLimit();
        if (memoryLimit > prevMemoryLimit) {
            OlapLoggers.SERVER.info((Object)("[license] upgraded memory limit: " + memoryLimit));
            prevLixContent.reset(OlapLixContent.memoryLimit, (Object)memoryLimit);
            diSomething = true;
        }
        boolean prevRealTime = prevLixContent.isRealTimeAvailable();
        boolean realTime = lixContent.isRealTimeAvailable();
        if (!prevRealTime && realTime) {
            OlapLoggers.SERVER.info((Object)"[license] upgraded to real time");
            prevLixContent.reset(OlapLixContent.realTime, (Object)true);
            prevLixContent.reset(OlapLixContent.incrLoad, (Object)true);
            prevLixContent.reset(OlapLixContent.incrLoadCount, (Object)Integer.MAX_VALUE);
            this.getOlapEngineComponent().upgradeToRealTime();
            diSomething = true;
        }
        if (!prevLixContent.isAsyncLoadReadAvailable() && lixContent.isAsyncLoadReadAvailable()) {
            OlapLoggers.SERVER.info((Object)"[license] upgraded to async. load");
            prevLixContent.reset(OlapLixContent.asyncLoad, (Object)true);
            diSomething = true;
        }
        if (!prevLixContent.isTablePartitioningAvailable() && lixContent.isTablePartitioningAvailable()) {
            OlapLoggers.SERVER.info((Object)"[license] upgraded to table partitioning");
            prevLixContent.reset(OlapLixContent.tablePartitioning, (Object)true);
            diSomething = true;
        }
        if (!prevLixContent.isFactsPartitioningAvailable() && lixContent.isFactsPartitioningAvailable()) {
            OlapLoggers.SERVER.info((Object)"[license] upgraded to facts partitioning");
            prevLixContent.reset(OlapLixContent.factsPartitioning, (Object)true);
            diSomething = true;
        }
        if (!prevLixContent.isIndexPartitioningAvailable() && lixContent.isIndexPartitioningAvailable()) {
            OlapLoggers.SERVER.info((Object)"[license] upgraded to index partitioning");
            prevLixContent.reset(OlapLixContent.indexPartitioning, (Object)true);
            diSomething = true;
        }
        if (!prevLixContent.isMmapFactsAvailable() && lixContent.isMmapFactsAvailable()) {
            OlapLoggers.SERVER.info((Object)"[license] upgraded to facts in files");
            prevLixContent.reset(OlapLixContent.mmapFacts, (Object)true);
            diSomething = true;
        }
        if (diSomething) {
            prevLixContent.reset(OlapLixContent.issued, (Object)lixContent.getIssued());
            prevLixContent.reset(OlapLixContent.major, (Object)lixContent.getMajor());
            prevLixContent.reset(OlapLixContent.minor, (Object)lixContent.getMinor());
            prevLixContent.reset(OlapLixContent.patch, (Object)lixContent.getPatch());
        }
    }

    @Nullable
    public abstract IcCubeHttpComponent getHttpComponent();

    public abstract int getHttpMaxFormContentSize();

    public IcCubeAIConfiguration getAIConfiguration() {
        return this.configuration.getAIConfiguration();
    }
}

