/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.embedded;

import crazydev.common.exception.CdFatalErrorHandler;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.embedded.IcCubeExpiryDateNotification;
import crazydev.iccube.embedded.checker.ExpiryDateChecker;
import crazydev.iccube.embedded.checker.GCInfoChecker;
import crazydev.iccube.embedded.checker.OOMChecker;
import crazydev.iccube.embedded.checker.RamUsageChecker;
import crazydev.iccube.embedded.checker.SystemLoadChecker;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.configuration.IcCubeServerProperties;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class IcCubeCheckers {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final OlapLixContent lixContent;
    private final IcCubeServerApplicationContext context;
    private final CdFatalErrorHandler fatalErrorHandler;

    public IcCubeCheckers(OlapLixContent lixContent, IcCubeServerApplicationContext context, CdFatalErrorHandler fatalErrorHandler) {
        this.lixContent = lixContent;
        this.context = context;
        this.fatalErrorHandler = fatalErrorHandler;
        IcCubeEngine.expiryDateNotification = new IcCubeExpiryDateNotification();
    }

    public void start() {
        int delayS;
        OlapLoggers.GENERAL.info((Object)"[server] checkers starting");
        IcCubeServerConfiguration conf = this.context.getConfiguration();
        IcCubeServerProperties props = conf.getProperties();
        OlapNotificationService svc = this.context.getEngine().getNotificationService();
        this.executor.scheduleWithFixedDelay(new ExpiryDateChecker(this.fatalErrorHandler, this.lixContent, svc), 0L, 1L, TimeUnit.HOURS);
        int limit = this.lixContent.getMemoryLimit();
        if (limit != Integer.MAX_VALUE) {
            this.executor.scheduleWithFixedDelay(new RamUsageChecker(this.fatalErrorHandler, limit), 10L, 20L, TimeUnit.SECONDS);
        }
        if (props.isGcInfoActive()) {
            int delayMS = props.getGcInfoMillis();
            this.executor.scheduleWithFixedDelay(new GCInfoChecker(this.context), 3L, delayMS, TimeUnit.MILLISECONDS);
        }
        if ((delayS = props.getLoadAverageSeconds()) > 0) {
            this.executor.scheduleWithFixedDelay(new SystemLoadChecker(this.context), 3L, delayS, TimeUnit.SECONDS);
        }
        svc = this.context.getEngine().getNotificationService();
        this.executor.scheduleWithFixedDelay(new OOMChecker(svc), 20L, 60L, TimeUnit.SECONDS);
        OlapLoggers.GENERAL.info((Object)"[server] checkers started");
    }

    public void stop() {
        OlapLoggers.GENERAL.info((Object)"[server] checkers shutdown requested");
        this.executor.shutdownNow();
        OlapLoggers.GENERAL.info((Object)"[server] checkers bye");
    }
}

