/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.embedded;

import crazydev.common.exception.CdException;
import crazydev.common.exception.CdFatalErrorHandler;
import crazydev.iccube.authorization.permissions.service.OlapNotEnabledRolePermissionsService;
import crazydev.iccube.builder.executor.pool.OlapBuilderTableExecutorPool;
import crazydev.iccube.cluster.master.backup.save.M_BackupManagerContainer;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.master.request.M_CancellingRequestManager;
import crazydev.iccube.cluster.master.request.M_DefaultCancellingRequestManager;
import crazydev.iccube.cluster.master.request.M_DefaultTimeoutRequestManager;
import crazydev.iccube.cluster.master.request.M_NoCancellingRequestManager;
import crazydev.iccube.cluster.master.request.M_NoTimeoutRequestManager;
import crazydev.iccube.cluster.master.request.M_TimeoutRequestManager;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.OlapWebAppConfiguration;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.configuration.component.OlapEngineJavaMdxConfiguration;
import crazydev.iccube.configuration.component.plugins.OlapConfPluginClassProcessor;
import crazydev.iccube.de.schlichtherle.util.ObfuscatedString;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.embedded.IcCubeCheckers;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.embedded.IcCubeEngineHelper;
import crazydev.iccube.embedded.IcCubeEnginePingHelper;
import crazydev.iccube.embedded.IcCubeEngineUserHelper;
import crazydev.iccube.embedded.IcCubeTenantHomeSetup;
import crazydev.iccube.gwt.base.shared.comm.GwtCancelledReply;
import crazydev.iccube.gwt.base.shared.comm.GwtExceptionReply;
import crazydev.iccube.gwt.base.shared.comm.GwtReply;
import crazydev.iccube.gwt.base.shared.comm.request.GwtQuery;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingComponent;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingComponentConfiguration;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.roles.common.GwtRoleSetUpApplicationPermissionsQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.users.common.GwtUserSetUpAuthenticationServiceQuery;
import crazydev.iccube.housekeeper.M_DefaultHouseKeeper;
import crazydev.iccube.housekeeper.M_HouseKeeper;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.bigbrother.IOlapBigBrotherMgr;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutorsManager;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.executor.IOlapExecutor;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestInfo;
import crazydev.iccube.request.log.OlapRequestTracker;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.IcCubeServerListener;
import crazydev.iccube.server.authentication.IcCubeAuthenticationServiceWrapper;
import crazydev.iccube.server.authentication.IcCubeEmptyAuthenticationService;
import crazydev.iccube.server.authorization.IcCubeAuthorizationServiceConfiguration;
import crazydev.iccube.server.bigbrother.IcBigBrotherCounterFactory;
import crazydev.iccube.server.bigbrother.IcBigBrotherMgr;
import crazydev.iccube.server.bigbrother.IcBigBrotherMgrConfigurations;
import crazydev.iccube.server.bigbrother.counters.IcBigBrotherCounter;
import crazydev.iccube.server.configuration.IcCubeCancellingRequestConfiguration;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.configuration.IcCubeTimeoutRequestConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.gvi.GviComponent;
import crazydev.iccube.server.gvi.GviComponentConfiguration;
import crazydev.iccube.server.http.IcCubeHttpComponent;
import crazydev.iccube.server.http.IcCubeHttpComponentConfiguration;
import crazydev.iccube.server.print.IcCubePrintComponent;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.request.executor.IcCubeServerTaskExecutor;
import crazydev.iccube.server.request.processor.gvi.IcCubeGviRequestProcessor;
import crazydev.iccube.server.request.processor.gwt.IcCubeGwtRequestProcessor;
import crazydev.iccube.server.request.processor.print.IcCubePrintRequestProcessor;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.xmla.IcCubeXmlaRequestProcessor;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequest;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.server.xmla.IcCubeXmlaComponent;
import crazydev.iccube.server.xmla.IcCubeXmlaComponentConfiguration;
import crazydev.iccube.tenants.OlapTenantDefinition;
import crazydev.iccube.tenants.OlapTenantHomeSetup;
import crazydev.iccube.tenants.OlapTenantManager;
import crazydev.iccube.ux.common.model.UxModeTypeRepository;
import crazydev.iccube.ux.processor.UxComponent;
import crazydev.iccube.ux.processor.UxRequestProcessor;
import crazydev.iccube.ux.processor.conf.UxComponentConfiguration;
import crazydev.iccube.ux.processor.servlet.UxRestApiServlet;
import crazydev.xmla.server.iccube.server.engine.XmlaServerProxy;
import java.lang.reflect.InvocationTargetException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeAbstractMasterEngine
extends IcCubeEngine {
    private final IcCubeCheckers checkers;
    @Nullable
    private final IcBigBrotherMgr bigBrother;
    private final IcCubeServerTaskExecutor taskExecutor;
    private final IcCubeGwtRequestProcessor gwtRequestProcessor;
    private final UxRequestProcessor uxRequestProcessor;
    private final IcCubeGviRequestProcessor gviRequestProcessor;
    private final IcCubePrintRequestProcessor printRequestProcessor;
    private final IcCubeXmlaRequestProcessor xmlaRequestProcessor;
    private final IcCubeRequestStatusManager requestStatusManager;
    private final M_CancellingRequestManager cancellingRequestManager;
    private final M_TimeoutRequestManager timeoutRequestManager;
    private final M_HouseKeeper houseKeeper;
    private final M_BackupManagerContainer backupManager;
    @Nullable
    private final IcCubeHttpComponent httpComponent;
    @Nullable
    private final IcCubeXmlaComponent xmlaComponent;
    @Nullable
    private final UxComponent uxComponent;
    @Nullable
    private final OlapReportingComponent reportingComponent;
    @Nullable
    private final GviComponent gviComponent;
    @Nullable
    private final IcCubePrintComponent printComponent;
    private final IcCubeScheduler schedulerAlerts;
    private final IcCubeScheduler schedulerSchemas;
    private final IcCubeAuthenticationServiceWrapper authenticationServiceWrapper;
    @Nullable
    private final OlapTenantManager tenantManager;
    private final UxModeTypeRepository uxModelTypeRepository;
    @Nullable
    private volatile IcCubePrintService printService;
    private volatile boolean printServiceSetupOnError;

    public IcCubeAbstractMasterEngine(CdFatalErrorHandler fatalErrorHandler, Object lix, OlapNotificationService notificationService, OlapRuntime runtime, IcCubeServerConfiguration configuration, OlapDirectories directories, boolean withMultiTenant) throws OlapConfigurationException {
        super(fatalErrorHandler, lix, notificationService, runtime, configuration, directories, withMultiTenant);
        OlapEngineComponentConfiguration olapEngineConfiguration = configuration.getOlapEngineConfiguration();
        OlapLixContent lixContent = (OlapLixContent)lix;
        IcCubeCancellingRequestConfiguration cancellingRequestConfiguration = configuration.getCancellingRequestConfiguration();
        this.cancellingRequestManager = cancellingRequestConfiguration != null && cancellingRequestConfiguration.isActive() ? new M_DefaultCancellingRequestManager(cancellingRequestConfiguration.getPeriodS(), cancellingRequestConfiguration.getTimeoutS()) : M_NoCancellingRequestManager.INSTANCE;
        IcCubeTimeoutRequestConfiguration timeoutRequestConfiguration = configuration.getTimeoutRequestConfiguration();
        this.timeoutRequestManager = timeoutRequestConfiguration != null && timeoutRequestConfiguration.isActive() && ((OlapLixContent)lix).isTimeoutAvailable() ? new M_DefaultTimeoutRequestManager(timeoutRequestConfiguration.getPeriodS()) : M_NoTimeoutRequestManager.INSTANCE;
        OlapWebAppConfiguration webAppConfiguration = configuration.getWebAppConfiguration();
        this.requestStatusManager = new IcCubeRequestStatusManager(webAppConfiguration != null && webAppConfiguration.isSessionLess(), this.cancellingRequestManager, this.timeoutRequestManager);
        this.houseKeeper = new M_DefaultHouseKeeper();
        this.backupManager = new M_BackupManagerContainer(lixContent.isBackupAvailable(), olapEngineConfiguration.getBackupConfiguration());
        this.taskExecutor = new IcCubeServerTaskExecutor(olapEngineConfiguration, this.requestStatusManager);
        OlapMdxExecutorsManager mdxExecutorsManager = new OlapMdxExecutorsManager(lixContent.isSimultaneousMdxQueryAvailable(), lixContent.isMultithreadedMdxQueryAvailable(), olapEngineConfiguration.getMdxEvalConfiguration());
        OlapBuilderTableExecutorPool builderTableExecutorPool = new OlapBuilderTableExecutorPool();
        OlapEngineJavaMdxConfiguration javaMdxConfiguration = olapEngineConfiguration.getJavaMdxConfiguration();
        boolean javaMdxActive = javaMdxConfiguration != null && javaMdxConfiguration.isActive();
        boolean javaMdxNativeActive = olapEngineConfiguration.isJavaMdxNativesActivated();
        OlapFunctionRepository functionRepository = new OlapFunctionRepository();
        IcCubeHttpComponentConfiguration httpComponentConfiguration = configuration.getHttpConfiguration();
        if (httpComponentConfiguration != null) {
            OlapLoggers.GENERAL.debug((Object)"[server] creating the HTTP component");
            this.httpComponent = new IcCubeHttpComponent(runtime, fatalErrorHandler, lixContent, httpComponentConfiguration, configuration.getWebAppConfiguration());
        } else {
            OlapLoggers.GENERAL.debug((Object)"[server] HTTP component NOT enabled");
            this.httpComponent = null;
        }
        if (!lixContent.isMonitoringAvailable()) {
            this.bigBrother = null;
        } else {
            IcBigBrotherMgrConfigurations monitoringConfigurations = configuration.getMonitoringConfigurations();
            if (monitoringConfigurations != null && monitoringConfigurations.isActivated()) {
                OlapLoggers.GENERAL.debug((Object)"[server] creating the big-brother component");
                this.bigBrother = new IcBigBrotherMgr(this, monitoringConfigurations.getConfigurations());
                if (this.requestStatusManager == null) {
                    throw new RuntimeException("internal error : missing requestStatusManager");
                }
                if (this.taskExecutor == null) {
                    throw new RuntimeException("internal error : missing taskExecutor");
                }
                List<IcBigBrotherCounter> bigBrotherCounters = IcCubeAbstractMasterEngine.setupBigBrotherCounters(this.requestStatusManager, this.taskExecutor, mdxExecutorsManager, builderTableExecutorPool, this.httpComponent);
                IcBigBrotherCounterFactory.setupExtraCollectors(bigBrotherCounters);
            } else {
                this.bigBrother = null;
            }
        }
        this.tenantManager = withMultiTenant ? new OlapTenantManager(runtime, directories.getTenantsDirectory__()) : new OlapTenantManager(runtime);
        OlapEngineComponent olapEngineComponent = new OlapEngineComponent((Object)lixContent, olapEngineConfiguration, (IOlapBigBrotherMgr)this.bigBrother, runtime, directories, functionRepository, builderTableExecutorPool, withMultiTenant);
        OlapLoggers.GENERAL.debug((Object)"[server] creating the server cache manager");
        OlapCacheManager cacheManager = new OlapCacheManager(olapEngineComponent);
        OlapLoggers.GENERAL.debug((Object)"[server] creating the request executor");
        this.gwtRequestProcessor = new IcCubeGwtRequestProcessor(this.taskExecutor, this.requestStatusManager);
        this.uxRequestProcessor = new UxRequestProcessor(configuration.getUxConfiguration(), this.taskExecutor, this.requestStatusManager);
        this.gviRequestProcessor = new IcCubeGviRequestProcessor(configuration.getGviConfiguration(), this.taskExecutor, this.requestStatusManager);
        this.printRequestProcessor = new IcCubePrintRequestProcessor(this.taskExecutor, this.requestStatusManager);
        this.xmlaRequestProcessor = new IcCubeXmlaRequestProcessor(this.taskExecutor, this.requestStatusManager);
        IOlapPermissionsService authorizationService = this.setupRoleService(olapEngineComponent, configuration.getAuthorizationService());
        IOlapServiceConfiguration authorizationServiceConfiguration = configuration.getAuthorizationService().createServiceConfiguration();
        OlapReportingComponentConfiguration reportingConfiguration = configuration.getReportingConfiguration();
        try {
            this.olapEngineApplicationContext = new OlapEngineApplicationContext(configuration.getClusterConfiguration().asOlapConfiguration(), withMultiTenant, this.tenantManager, javaMdxActive, javaMdxNativeActive, notificationService, runtime, configuration.getProperties().getFileSystemRoot(), directories, configuration.getUserDefinedProperties(), authorizationService, authorizationServiceConfiguration, cacheManager, olapEngineComponent, mdxExecutorsManager, this.requestStatusManager, this.backupManager, this.houseKeeper);
            this.olapEngineApplicationContext.setTaskExecutor((IOlapExecutor)this.taskExecutor);
        }
        catch (OlapAuthenticationServiceException ex) {
            fatalErrorHandler.handle((Throwable)ex, -1);
            throw new RuntimeException("internal error : failed to setup the icCube engine application context.");
        }
        M_LocalCluster cluster = this.olapEngineApplicationContext.getCluster();
        cacheManager.attachCluster(cluster);
        this.authenticationServiceWrapper = new IcCubeAuthenticationServiceWrapper();
        IcCubeXmlaComponentConfiguration xmlaComponentConfiguration = configuration.getXmlaConfiguration();
        if (!lixContent.isMissing() && xmlaComponentConfiguration != null) {
            OlapLoggers.GENERAL.debug((Object)"[server] creating the XMLA component");
            this.xmlaComponent = new IcCubeXmlaComponent(xmlaComponentConfiguration);
        } else {
            OlapLoggers.GENERAL.debug((Object)"[server] XMLA component NOT enabled");
            this.xmlaComponent = null;
        }
        UxComponentConfiguration uxComponentConfiguration = configuration.getUxConfiguration();
        if (uxComponentConfiguration != null) {
            OlapLoggers.GENERAL.debug((Object)"[server] creating the UX component");
            this.uxComponent = new UxComponent(runtime, directories.getTmpDirectory__(), uxComponentConfiguration, configuration.getMimeTypesConfiguration());
        } else {
            OlapLoggers.GENERAL.debug((Object)"[server] UX component NOT enabled");
            this.uxComponent = null;
        }
        OlapReportingComponentConfiguration reportingComponentConfiguration = configuration.getReportingConfiguration();
        if (!lixContent.isMissing() && reportingComponentConfiguration != null) {
            OlapLoggers.GENERAL.debug((Object)"[server] creating the Reporting component");
            this.reportingComponent = new OlapReportingComponent(runtime, directories.getTmpDirectory__(), directories.getDocsRepositoryDirectory__(), reportingComponentConfiguration, configuration.getMimeTypesConfiguration());
        } else {
            OlapLoggers.GENERAL.debug((Object)"[server] Reporting component NOT enabled");
            this.reportingComponent = null;
        }
        GviComponentConfiguration gviComponentConfiguration = configuration.getGviConfiguration();
        if (!lixContent.isMissing() && gviComponentConfiguration != null) {
            OlapLoggers.GENERAL.debug((Object)"[server] creating the GVI component");
            UxRestApiServlet restApiServlet = this.uxComponent != null ? this.uxComponent.getRestApiServlet() : null;
            this.gviComponent = new GviComponent(gviComponentConfiguration, restApiServlet);
        } else {
            OlapLoggers.GENERAL.debug((Object)"[server] GVI component NOT enabled");
            this.gviComponent = null;
        }
        IcCubePrintComponentConfiguration printComponentConfiguration = configuration.getPrintConfiguration();
        if (!lixContent.isMissing() && printComponentConfiguration != null) {
            OlapLoggers.GENERAL.debug((Object)("[server] creating the Print component (" + lixContent.isPrintServerAvailable() + ")"));
            this.printComponent = new IcCubePrintComponent(printComponentConfiguration);
            this.printService = IcCubePrintService.create(this.httpComponent, this.printComponent, lixContent.isPrintServerAvailable(), directories, printComponentConfiguration);
        } else {
            OlapLoggers.GENERAL.debug((Object)"[server] Print component NOT enabled");
            this.printComponent = null;
            this.printService = null;
        }
        OlapLoggers.GENERAL.debug((Object)"[server] creating the application context");
        this.applicationContext = new IcCubeServerApplicationContext(this);
        this.checkers = new IcCubeCheckers(lixContent, this.applicationContext, fatalErrorHandler);
        this.checkers.start();
        this.tenantManager.set((OlapTenantHomeSetup)new IcCubeTenantHomeSetup(this.applicationContext));
        this.uxModelTypeRepository = new UxModeTypeRepository();
        this.uxModelTypeRepository.assertTypeConsistency(this.applicationContext);
        OlapLoggers.GENERAL.debug((Object)"[server] done");
        this.schedulerAlerts = new IcCubeScheduler(IcCubeSchedulerKind.ALERTS, this);
        this.schedulerSchemas = new IcCubeScheduler(IcCubeSchedulerKind.SCHEMAS, this);
        if (this.bigBrother != null) {
            this.bigBrother.start();
        }
        OlapLoggers.GENERAL.info((Object)"icCube Server Created");
        if (runtime.isForPing()) {
            IcCubeEnginePingHelper.ping(lixContent.getPing(), this.httpComponent.getListeningPort(), lixContent.getType(), lixContent.getHolderNameX(), this.requestStatusManager);
        }
    }

    private void setupSchedulers() {
        OlapEngineApplicationContext appContext = this.getOlapEngineApplicationContext();
        OlapRuntimeContext runtimeContext = OlapRuntimeContext.create((OlapEngineApplicationContext)appContext);
        this.setupSchedulers(runtimeContext);
        if (appContext.isWithMultiTenant()) {
            OlapTenantManager tenants = this.getTenantManager();
            for (OlapTenantDefinition tenantDefinition : tenants.getTenantDefinitions()) {
                OlapTenant tenant = new OlapTenant(tenantDefinition.getName(), tenantDefinition.getDirectory());
                OlapRuntimeContext runtimeContext2 = OlapRuntimeContext.create((OlapEngineApplicationContext)appContext, (OlapTenant)tenant);
                this.setupSchedulers(runtimeContext2);
            }
        }
    }

    private void setupSchedulers(OlapRuntimeContext runtimeContext) {
        IcCubeAbstractMasterEngine.setupScheduler(runtimeContext, this.schedulerAlerts);
        IcCubeAbstractMasterEngine.setupScheduler(runtimeContext, this.schedulerSchemas);
    }

    private static void setupScheduler(OlapRuntimeContext runtimeContext, IcCubeScheduler scheduler) {
        String tenantInfo = OlapTenant.info((OlapTenant)runtimeContext.getTenant());
        IcCubeSchedulerKind kind = scheduler.getKind();
        OlapLoggers.SCHEDULER.info((Object)"");
        OlapLoggers.SCHEDULER.info((Object)(kind.logName() + tenantInfo + " setup started"));
        scheduler.applyDefinitionOnStartup(runtimeContext);
        OlapLoggers.SCHEDULER.info((Object)(kind.logName() + tenantInfo + " setup completed"));
    }

    private IOlapPermissionsService setupRoleService(OlapEngineComponent olapEngine, IcCubeAuthorizationServiceConfiguration authorizationService) {
        OlapLixContent lixContent = olapEngine.getLixContent();
        if (lixContent.isAccessRightsAvailable()) {
            return this.doSetupRoleService(authorizationService);
        }
        return new OlapNotEnabledRolePermissionsService();
    }

    private IOlapPermissionsService doSetupRoleService(IcCubeAuthorizationServiceConfiguration authorizationService) {
        try {
            String className = authorizationService.getServiceClass();
            Class<?> clazz = Class.forName(className);
            if (!IOlapPermissionsService.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("icCube authorization service error : type mismatch (expected:" + IOlapPermissionsService.class.getName() + ") (actual:" + clazz.getName() + ")");
            }
            IOlapPermissionsService service = (IOlapPermissionsService)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return service;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("authorization service setup error", ex);
        }
    }

    @Override
    public boolean isUxActive() {
        return this.uxComponent != null;
    }

    @Override
    @Nullable
    public <T> T getServletContextAttribute(String name) {
        if (this.httpComponent != null) {
            return this.httpComponent.getServletContextAttribute(name);
        }
        return null;
    }

    @Override
    @Nullable
    public IcCubeHttpComponent getHttpComponent() {
        return this.httpComponent;
    }

    @Override
    public int getHttpMaxFormContentSize() {
        if (this.httpComponent != null) {
            return this.httpComponent.getMaxFormContentSize();
        }
        return -1;
    }

    @Override
    public int getHttpSessionCount() {
        if (this.httpComponent != null) {
            return this.httpComponent.getHttpSessionCount();
        }
        return -1;
    }

    @Override
    public int getXmlaSessionCount() {
        if (this.xmlaComponent != null) {
            return this.xmlaComponent.getXmlaSessionCount();
        }
        return -1;
    }

    @Override
    public String getShortName() {
        return null;
    }

    @Override
    public OlapTenantManager getTenantManager() {
        if (this.tenantManager == null) {
            throw new RuntimeException("internal error: missing tenant manager");
        }
        return this.tenantManager;
    }

    @Override
    public IOlapAuthenticationService getAuthenticationService() {
        return this.authenticationServiceWrapper;
    }

    @Override
    public void setAuthenticationService(IOlapAuthenticationService authenticationService) {
        OlapEngineComponent olapEngine = this.applicationContext.getOlapEngineComponent();
        OlapLixContent lix = olapEngine.getLixContent();
        if (!lix.isAuthenticationServiceAvailable(authenticationService)) {
            OlapLoggers.GENERAL.error((Object)(new ObfuscatedString(new long[]{-6886371512487322092L, 5477269633348666162L, -1576812697367120190L, 668170936885910059L, 3012254476263944798L, -6375891725376055852L}).toString() + authenticationService.getClass().getName()));
            System.exit(-2);
        }
        this.authenticationServiceWrapper.setService(authenticationService);
    }

    @Override
    @Nullable
    public IcCubePrintService getPrintService() {
        return this.printService;
    }

    @Override
    public boolean isPrintServiceSetupOnError() {
        return this.printServiceSetupOnError;
    }

    @Override
    public IcCubeRequestStatusManager getRequestStatusManager() {
        return this.requestStatusManager;
    }

    @Override
    public IcCubeGwtRequestProcessor getGwtRequestProcessor() {
        return this.gwtRequestProcessor;
    }

    @Override
    public UxRequestProcessor getUxRequestProcessor() {
        return this.uxRequestProcessor;
    }

    @Override
    public IcCubeGviRequestProcessor getGviRequestProcessor() {
        return this.gviRequestProcessor;
    }

    @Override
    public IcCubePrintRequestProcessor getPrintRequestProcessor() {
        return this.printRequestProcessor;
    }

    @Override
    public IcCubeXmlaRequestProcessor getXmlaRequestProcessor() {
        return this.xmlaRequestProcessor;
    }

    @Override
    public XmlaServerProxy getXmlaServerProxy() {
        return this.xmlaComponent.getXmlaServerProxy();
    }

    @Override
    public IcCubeScheduler getScheduler(IcCubeSchedulerKind kind) {
        switch (kind) {
            case ALERTS: {
                return this.schedulerAlerts;
            }
            case SCHEMAS: {
                return this.schedulerSchemas;
            }
        }
        throw new RuntimeException("internal error: unexpected scheduler kind [" + String.valueOf((Object)kind) + "]");
    }

    @Override
    public M_BackupManagerContainer getBackupManager() {
        return this.backupManager;
    }

    @Override
    @Nullable
    public OlapConfPluginClassProcessor createUiModelConverterPluginClassProcessor(boolean allDataSourceLicensed) {
        return null;
    }

    @Override
    @Nullable
    public OlapConfPluginClassProcessor createUxModelPluginClassProcessor(boolean allDataSourceLicensed) {
        if (this.uxComponent != null) {
            return this.uxModelTypeRepository.createPluginClassProcessor();
        }
        return null;
    }

    @Override
    public UxModeTypeRepository getUxModelTypeRepository() {
        return this.uxModelTypeRepository;
    }

    @Override
    public void setUpServicesAndComponents() throws CdException {
        OlapLoggers.GENERAL.info((Object)"Setup Plugins...");
        this.setUpPlugins();
        OlapLoggers.GENERAL.info((Object)"Plugins Setup Done");
        OlapLoggers.GENERAL.info((Object)"Setup Authentication Service...");
        this.setUpAuthenticationService();
        OlapLoggers.GENERAL.info((Object)"Authentication Service Setup Done");
        OlapLoggers.GENERAL.info((Object)"Setup Roles/Permissions...");
        this.setUpApplicationPermissions();
        OlapLoggers.GENERAL.info((Object)"Roles/Permissions Setup Done");
        OlapLoggers.GENERAL.info((Object)"Setup Print Service...");
        this.setUpPrintService();
        OlapLoggers.GENERAL.info((Object)"Print Service Setup Done");
        OlapLoggers.GENERAL.info((Object)"Setup HTTP Handlers...");
        this.setupHttpHandlers();
        OlapLoggers.GENERAL.info((Object)"Setup HTTP Handlers Done");
    }

    private void setUpAuthenticationService() {
        try {
            GwtUserSetUpAuthenticationServiceQuery request = new GwtUserSetUpAuthenticationServiceQuery();
            this.submitAndWaitGwtRequestEx(request);
        }
        catch (Exception unlikely) {
            OlapLoggers.AUTHENTICATION.error((Object)"(icCubeServer) authentication service setup unexpected fatal error", (Throwable)unlikely);
            OlapLoggers.AUTHENTICATION.error((Object)"(icCubeServer) authentication service setup : fallback to anonymous logon only.");
            this.setAuthenticationService((IOlapAuthenticationService)new IcCubeEmptyAuthenticationService());
        }
    }

    @Override
    public List<String> getKnownUserNames() {
        List<String> names = this.authenticationServiceWrapper.getUserNames();
        names.add("anonymous");
        return names;
    }

    private void setUpApplicationPermissions() {
        try {
            GwtRoleSetUpApplicationPermissionsQuery request = new GwtRoleSetUpApplicationPermissionsQuery();
            this.submitAndWaitGwtRequestEx(request);
        }
        catch (Exception unlikely) {
            OlapLoggers.AUTHORIZATION.error((Object)"[auth] (icCubeServer) roles/permissions setup unexpected fatal error", (Throwable)unlikely);
            OlapLoggers.AUTHORIZATION.error((Object)"[auth] (icCubeServer) roles/permissions setup : fallback to administrator role only.");
            IOlapPermissionsService service = this.applicationContext.getRolePermissionsService();
            service.setupOnStartupError();
        }
    }

    private void setUpPrintService() throws CdException {
        if (this.printService != null) {
            try {
                this.printService.setUp();
            }
            catch (Throwable ex) {
                OlapLoggers.GENERAL.error((Object)"Setup Print Service error (print cancelled)", ex);
                this.printService = null;
                this.printServiceSetupOnError = true;
            }
        }
    }

    private void setupHttpHandlers() throws CdException {
        if (this.httpComponent != null) {
            this.httpComponent.setupHandlers(this.runtime, this.configuration.getDirectories(), this.applicationContext, this.uxComponent, this.xmlaComponent, this.reportingComponent, this.gviComponent, this.printComponent);
        }
    }

    @Override
    public void start(@Nullable IcCubeServerListener listener, boolean setupLoadOnStartupSchemas) throws Exception {
        OlapLixContent lixContent;
        OlapLoggers.CHECKPOINTS.info((Object)"[ic3] icCube Server starting");
        OlapLoggers.GENERAL.info((Object)"");
        OlapLoggers.GENERAL.info((Object)"Starting the icCube Server...");
        OlapLoggers.GENERAL.info((Object)"[JDBC] drivers registration started");
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            OlapLoggers.GENERAL.info((Object)("[JDBC] driver : " + driver.getClass().getName()));
        }
        OlapLoggers.GENERAL.info((Object)"[JDBC] drivers registration completed");
        if (this.httpComponent != null) {
            this.httpComponent.start();
            if (listener != null) {
                listener.onHttpComponentStarted(this.httpComponent);
            }
        }
        if (this.xmlaComponent != null) {
            this.xmlaComponent.start();
            if (listener != null) {
                listener.onXmlaComponentStarted(this.xmlaComponent);
            }
        }
        if ((lixContent = this.getOlapEngineComponent().getLixContent()).isSchedulerAvailable()) {
            OlapLoggers.CHECKPOINTS.info((Object)"[ic3] icCube Server starting schedulers");
            this.setupSchedulers();
        }
        OlapLoggers.GENERAL.info((Object)"");
        OlapLoggers.GENERAL.info((Object)"icCube Server started & listening");
        OlapLoggers.GENERAL.info((Object)"");
        OlapLoggers.GENERAL.info((Object)"[docs] icCube repository setup sequence started");
        boolean reportServerAvailable = lixContent.isReportServerAvailable();
        boolean docsRepositorySetupAtStartup = this.isDocsRepositorySetupAtStartup();
        OlapLoggers.GENERAL.info((Object)("[docs]   docs available : " + reportServerAvailable));
        OlapLoggers.GENERAL.info((Object)("[docs]   docs @ startup : " + docsRepositorySetupAtStartup));
        if (reportServerAvailable && docsRepositorySetupAtStartup) {
            OlapLoggers.CHECKPOINTS.info((Object)"[ic3] icCube Server starting repository");
            this.setupDocsRepositoryNow();
        }
        OlapLoggers.GENERAL.info((Object)"[docs] icCube repository setup sequence completed");
        OlapLoggers.GENERAL.info((Object)("icCube loading schemas @ startup : " + setupLoadOnStartupSchemas));
        OlapLoggers.CHECKPOINTS.info((Object)"[ic3] icCube Server ready");
        this.setupLoadOnStartupSchemas(listener, setupLoadOnStartupSchemas);
    }

    protected void setupLoadOnStartupSchemas(@Nullable IcCubeServerListener listener, boolean setupLoadOnStartupSchemas) {
        if (setupLoadOnStartupSchemas) {
            this.setUpLoadOnStartupSchemas(listener);
        }
    }

    private boolean isDocsRepositorySetupAtStartup() {
        return System.getProperty("icCube.dev.testRunMode") == null;
    }

    protected void setUpLoadOnStartupSchemas(@Nullable IcCubeServerListener listener) {
        if (listener != null && !listener.onBeforeLoadOnStartupSchemas()) {
            OlapLoggers.GENERAL.info((Object)"icCube loading schemas @ startup : not required");
            return;
        }
        OlapLoggers.GENERAL.info((Object)"Fire load on startup schemas thread");
        IcCubeEngineHelper.setUpLoadOnStartupSchemas(this, this.getOlapEngineComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GwtInfo submitAndWaitGwtRequestEx(GwtQuery query, IcCubeEngineUserHelper sessionHelper) {
        OlapRequestId requestId = OlapRequestId.next((OlapRequestType)OlapRequestType.GWT, (String)query.getClientUUID());
        OlapChattyRequest chattyRequest = IcCubeGwtServerRequest.isChattyRequest(query);
        OlapRequestVerbosity verbosity = IcCubeGwtServerRequest.getVerbosity(query);
        OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
        OlapRequestTracker.onInternalSubmitStarted((OlapRequestInfo)requestInfo);
        try {
            IcCubeGwtServerRequest request = new IcCubeGwtServerRequest(requestId, query);
            IcCubeGwtServerRequestContext requestContext = new IcCubeGwtServerRequestContext(sessionHelper.getSessionContext(), request, sessionHelper.getPermissions());
            GwtReply reply = (GwtReply)this.gwtRequestProcessor.processXyzRequest(requestContext, request);
            if (reply instanceof GwtExceptionReply) {
                GwtExceptionReply error = (GwtExceptionReply)reply;
                OlapLoggers.GENERAL.error((Object)("Request processing error : " + error.getInfo()));
                throw new RuntimeException("internal request processing error");
            }
            if (reply instanceof GwtCancelledReply) {
                OlapLoggers.GENERAL.error((Object)"Request processing error : CANCELLED");
                throw new RuntimeException("Request processing error");
            }
            Object REPLY = reply.getPayload();
            return REPLY;
        }
        finally {
            OlapRequestTracker.onInternalSubmitDone((OlapRequestInfo)requestInfo);
        }
    }

    @Override
    public GwtReply<? extends GwtInfo> submitAndWaitGwtRequest(IcCubeGwtServerRequest request, IcCubeGwtServerRequestContext requestContext) {
        GwtReply reply = (GwtReply)this.gwtRequestProcessor.processXyzRequest(requestContext, request);
        return reply;
    }

    @Override
    public void fireGwtRequest(GwtQuery query, IcCubeEngineUserHelper sessionHelper) {
        OlapRequestId requestId = OlapRequestId.next((OlapRequestType)OlapRequestType.GWT, (String)query.getClientUUID());
        OlapChattyRequest chattyRequest = IcCubeGwtServerRequest.isChattyRequest(query);
        OlapRequestVerbosity verbosity = IcCubeGwtServerRequest.getVerbosity(query);
        OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
        OlapRequestTracker.onInternalFired((OlapRequestInfo)requestInfo);
        IcCubeGwtServerRequest request = new IcCubeGwtServerRequest(requestId, query);
        IcCubeGwtServerRequestContext requestContext = new IcCubeGwtServerRequestContext(sessionHelper.getSessionContext(), request, sessionHelper.getPermissions());
        this.fireGwtRequest(request, requestContext);
    }

    private void fireGwtRequest(final IcCubeGwtServerRequest request, final IcCubeGwtServerRequestContext requestContext) {
        try {
            new Thread(new Runnable(){
                final /* synthetic */ IcCubeAbstractMasterEngine this$0;
                {
                    IcCubeAbstractMasterEngine icCubeAbstractMasterEngine = this$0;
                    Objects.requireNonNull(icCubeAbstractMasterEngine);
                    this.this$0 = icCubeAbstractMasterEngine;
                }

                @Override
                public void run() {
                    try {
                        this.this$0.gwtRequestProcessor.processXyzRequest(requestContext, request);
                    }
                    catch (RuntimeException ex) {
                        OlapLoggers.REQUESTS.warn((Object)"Internal request unexpected error", (Throwable)ex);
                    }
                }
            }, "internal-request-dispatcher").start();
        }
        catch (RuntimeException ex) {
            OlapLoggers.REQUESTS.warn((Object)"Internal request unexpected error", (Throwable)ex);
        }
    }

    @Override
    public void shutdown() {
        IcCubeRequestStatusManager requestStatusManager = this.getRequestStatusManager();
        requestStatusManager.onShutdownStarted();
        if (this.schedulerAlerts != null) {
            this.schedulerAlerts.shutdownNow();
        }
        if (this.schedulerSchemas != null) {
            this.schedulerSchemas.shutdownNow();
        }
        if (this.authenticationServiceWrapper != null) {
            this.authenticationServiceWrapper.shutdownNow();
        }
        if (this.httpComponent != null) {
            this.httpComponent.stop();
        }
        if (this.xmlaComponent != null) {
            this.xmlaComponent.stop();
        }
        if (this.taskExecutor != null) {
            this.taskExecutor.shutdownNow();
        }
        if (this.backupManager != null) {
            this.backupManager.shutdownNow();
        }
        if (this.cancellingRequestManager != null) {
            this.cancellingRequestManager.shutdownNow();
        }
        if (this.timeoutRequestManager != null) {
            this.timeoutRequestManager.shutdownNow();
        }
        if (this.houseKeeper != null) {
            this.houseKeeper.shutdownNow();
        }
        if (this.printService != null) {
            this.printService.shutdownNow();
        }
        if (this.bigBrother != null) {
            this.bigBrother.shutdownNow();
        }
        this.checkers.stop();
        super.shutdown();
    }
}

