/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.client.StatementStats;
import io.trino.jdbc.StageStats;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public final class QueryStats {
    private final String queryId;
    private final String state;
    private final boolean queued;
    private final boolean scheduled;
    private final OptionalDouble progressPercentage;
    private final int nodes;
    private final int totalSplits;
    private final int queuedSplits;
    private final int runningSplits;
    private final int completedSplits;
    private final long planningTimeMillis;
    private final long analysisTimeMillis;
    private final long cpuTimeMillis;
    private final long wallTimeMillis;
    private final long queuedTimeMillis;
    private final long elapsedTimeMillis;
    private final long finishingTimeMillis;
    private final long physicalInputTimeMillis;
    private final long processedRows;
    private final long processedBytes;
    private final long peakMemoryBytes;
    private final long physicalInputBytes;
    private final long physicalWrittenBytes;
    private final long internalNetworkInputBytes;
    private final Optional<StageStats> rootStage;

    public QueryStats(String queryId, String state, boolean queued, boolean scheduled, OptionalDouble progressPercentage, int nodes, int totalSplits, int queuedSplits, int runningSplits, int completedSplits, long planningTimeMillis, long analysisTimeMillis, long cpuTimeMillis, long wallTimeMillis, long queuedTimeMillis, long elapsedTimeMillis, long finishingTimeMillis, long physicalInputTimeMillis, long processedRows, long processedBytes, long peakMemoryBytes, long physicalInputBytes, long physicalWrittenBytes, long internalNetworkInputBytes, Optional<StageStats> rootStage) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.queued = queued;
        this.scheduled = scheduled;
        this.progressPercentage = Objects.requireNonNull(progressPercentage, "progressPercentage is null");
        this.nodes = nodes;
        this.totalSplits = totalSplits;
        this.queuedSplits = queuedSplits;
        this.runningSplits = runningSplits;
        this.completedSplits = completedSplits;
        this.planningTimeMillis = planningTimeMillis;
        this.analysisTimeMillis = analysisTimeMillis;
        this.cpuTimeMillis = cpuTimeMillis;
        this.wallTimeMillis = wallTimeMillis;
        this.queuedTimeMillis = queuedTimeMillis;
        this.elapsedTimeMillis = elapsedTimeMillis;
        this.finishingTimeMillis = finishingTimeMillis;
        this.physicalInputTimeMillis = physicalInputTimeMillis;
        this.processedRows = processedRows;
        this.processedBytes = processedBytes;
        this.peakMemoryBytes = peakMemoryBytes;
        this.physicalInputBytes = physicalInputBytes;
        this.physicalWrittenBytes = physicalWrittenBytes;
        this.internalNetworkInputBytes = internalNetworkInputBytes;
        this.rootStage = Objects.requireNonNull(rootStage, "rootStage is null");
    }

    static QueryStats create(String queryId, StatementStats stats) {
        return new QueryStats(queryId, stats.getState(), stats.isQueued(), stats.isScheduled(), stats.getProgressPercentage(), stats.getNodes(), stats.getTotalSplits(), stats.getQueuedSplits(), stats.getRunningSplits(), stats.getCompletedSplits(), stats.getPlanningTimeMillis(), stats.getAnalysisTimeMillis(), stats.getCpuTimeMillis(), stats.getWallTimeMillis(), stats.getQueuedTimeMillis(), stats.getElapsedTimeMillis(), stats.getFinishingTimeMillis(), stats.getPhysicalInputTimeMillis(), stats.getProcessedRows(), stats.getProcessedBytes(), stats.getPeakMemoryBytes(), stats.getPhysicalInputBytes(), stats.getPhysicalWrittenBytes(), stats.getInternalNetworkInputBytes(), Optional.ofNullable(stats.getRootStage()).map(StageStats::create));
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getState() {
        return this.state;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public OptionalDouble getProgressPercentage() {
        return this.progressPercentage;
    }

    public int getNodes() {
        return this.nodes;
    }

    public int getTotalSplits() {
        return this.totalSplits;
    }

    public int getQueuedSplits() {
        return this.queuedSplits;
    }

    public int getRunningSplits() {
        return this.runningSplits;
    }

    public int getCompletedSplits() {
        return this.completedSplits;
    }

    public long getPlanningTimeMillis() {
        return this.planningTimeMillis;
    }

    public long getAnalysisTimeMillis() {
        return this.analysisTimeMillis;
    }

    public long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    public long getWallTimeMillis() {
        return this.wallTimeMillis;
    }

    public long getQueuedTimeMillis() {
        return this.queuedTimeMillis;
    }

    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public long getFinishingTimeMillis() {
        return this.finishingTimeMillis;
    }

    public long getPhysicalInputTimeMillis() {
        return this.physicalInputTimeMillis;
    }

    public long getProcessedRows() {
        return this.processedRows;
    }

    public long getProcessedBytes() {
        return this.processedBytes;
    }

    public long getPeakMemoryBytes() {
        return this.peakMemoryBytes;
    }

    public long getPhysicalInputBytes() {
        return this.physicalInputBytes;
    }

    public long getPhysicalWrittenBytes() {
        return this.physicalWrittenBytes;
    }

    public long getInternalNetworkInputBytes() {
        return this.internalNetworkInputBytes;
    }

    public Optional<StageStats> getRootStage() {
        return this.rootStage;
    }
}

