/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling;

import io.trino.jdbc.$internal.client.CloseableIterator;
import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.spooling.InlineSegment;
import io.trino.jdbc.$internal.guava.base.Verify;
import io.trino.jdbc.$internal.guava.collect.AbstractIterator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;

class InlineSegmentIterator
extends AbstractIterator<List<Object>>
implements CloseableIterator<List<Object>> {
    private InlineSegment segment;
    private final QueryDataDecoder decoder;
    private final long rowsCount;
    private CloseableIterator<List<Object>> iterator;
    private long currentRow;

    public InlineSegmentIterator(InlineSegment segment, QueryDataDecoder decoder) {
        this.segment = Objects.requireNonNull(segment, "segment is null");
        this.decoder = Objects.requireNonNull(decoder, "decoder is null");
        this.rowsCount = segment.getRowsCount();
    }

    @Override
    protected List<Object> computeNext() {
        if (this.iterator == null) {
            try {
                this.iterator = this.decoder.decode(new ByteArrayInputStream(this.segment.getData()), this.segment.getMetadata());
                this.segment = null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (this.currentRow == this.rowsCount) {
            this.unload();
            return (List)this.endOfData();
        }
        ++this.currentRow;
        Verify.verify(this.iterator.hasNext(), "Iterator should have more rows, current: %s, count: %s", this.currentRow, this.rowsCount);
        return (List)this.iterator.next();
    }

    private void unload() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
    }
}

