/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.excel.datasource;

import com.github.pjfanning.xlsx.impl.StreamingCell;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelDataTable;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelType;
import crazydev.iccube.builder.excel.errors.OlapExcelBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.OlapBuilderAbstractTableRow;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

final class OlapBuilderExcelTableRow
extends OlapBuilderAbstractTableRow {
    private final OlapBuilderExcelDataTable table;
    private final Map<String, Integer> columnMapping;
    private final Row excelRow;
    private final boolean trimStrings;

    public OlapBuilderExcelTableRow(OlapBuilderExcelDataTable table, Map<String, Integer> columnMapping, Row excelRow) {
        this.table = table;
        this.trimStrings = table.getTrimStrings();
        this.columnMapping = columnMapping;
        this.excelRow = excelRow;
    }

    public Object getDataImpl(IOlapBuilderDataColumnDef columnDef) {
        String columnName = columnDef.getName();
        if ("#RowNumber".equals(columnName)) {
            return this.excelRow.getRowNum() + 1;
        }
        Integer cellPos = this.columnMapping.get(columnName);
        if (cellPos == null) {
            return null;
        }
        Cell cell = this.excelRow.getCell(cellPos.intValue());
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return this.evaluateAsFormula(cell, cellPos, columnDef);
        }
        OlapBuilderExcelType cellType = OlapBuilderExcelDataTable.getCellType(cell);
        switch (cellType) {
            case EXCEL_NUMERIC: {
                return cell.getNumericCellValue();
            }
            case EXCEL_DATE: {
                Date javaDate = cell.getDateCellValue();
                return new LocalDateTime(javaDate.getTime());
            }
            case EXCEL_STRING: {
                String value = cell.getStringCellValue();
                return this.trimStrings && value != null ? value.trim() : value;
            }
            case EXCEL_BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case EXCEL_BLANK: {
                return null;
            }
        }
        throw new OlapBuilderErrorException((OlapBuilderErrorCode)OlapExcelBuilderErrorCode.EXCEL_UNSUPPORTED_CELL_TYPE, new Serializable[]{cellType, Integer.valueOf(this.excelRow.getRowNum() + 1), cellPos});
    }

    @Nullable
    private Object evaluateAsFormula(Cell cell, int cellPos, IOlapBuilderDataColumnDef columnDef) {
        Object errorMessage;
        if (cell instanceof StreamingCell) {
            throw new OlapBuilderErrorException((OlapBuilderErrorCode)OlapExcelBuilderErrorCode.EXCEL_FORMULA_EVALUATION_EXCEPTION, new Serializable[]{this.table.getSheetName(), Integer.valueOf(cellPos), Integer.valueOf(cell.getRowIndex()), "The stream reader does not support formulas in cells, you can switch off the option in the datasource"});
        }
        try {
            Workbook workbook = cell.getSheet().getWorkbook();
            FormulaEvaluator formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
            CellValue cellValue = formulaEvaluator.evaluate(cell);
            CellType cellType = cellValue.getCellType();
            switch (cellType) {
                case NUMERIC: {
                    if (OlapBuilderExcelDataTable.isDateCell(cell)) {
                        Date javaDate = DateUtil.getJavaDate((double)cell.getNumericCellValue());
                        return new LocalDate(javaDate.getTime());
                    }
                    return cellValue.getNumberValue();
                }
                case BOOLEAN: {
                    return cellValue.getBooleanValue();
                }
                case STRING: {
                    return cellValue.getStringValue();
                }
                case BLANK: {
                    return null;
                }
            }
            errorMessage = "Unable to evaluate type [" + cellType.name() + "] -> [" + cellValue.formatAsString() + "]";
        }
        catch (RuntimeException ex) {
            errorMessage = ex.getLocalizedMessage();
        }
        throw new OlapBuilderErrorException((OlapBuilderErrorCode)OlapExcelBuilderErrorCode.EXCEL_FORMULA_EVALUATION_EXCEPTION, new Serializable[]{this.table.getSheetName(), Integer.valueOf(cell.getRowIndex() + 1), columnDef.getName(), errorMessage});
    }

    public boolean isEmpty() {
        if (this.excelRow == null) {
            return true;
        }
        for (Integer integer : this.columnMapping.values()) {
            Cell cell = this.excelRow.getCell(integer.intValue());
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }
}

