/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.excel.datasource;

import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelConnection;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelDataTable;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelType;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderNonEmptyDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.Sheet;

public class OlapBuilderExcelDataTableValidator
extends OlapBuilderNonEmptyDataTableValidator<OlapBuilderExcelConnection, IOlapBuilderDataSource<OlapBuilderExcelConnection>> {
    protected boolean checkTableExists(OlapRuntimeContext context, OlapBuilderExcelConnection connection, IOlapBuilderDataTableDef<OlapBuilderExcelConnection> dataTable) {
        Sheet sheet = connection.getSheet((OlapBuilderExcelDataTable)dataTable);
        return sheet != null;
    }

    protected void validateColumnWithTableColumn(OlapBuilderValidationContext context, IOlapBuilderDataTableDef<OlapBuilderExcelConnection> dataTable, IOlapBuilderDataColumnDef selectedColumn, IOlapBuilderDataColumnDef selectedColumnFromDS) {
        String tableType = selectedColumn.getTableType();
        String tableTypeFromDS = selectedColumnFromDS.getTableType();
        if (!OlapBuilderExcelType.EXCEL_UNDEFINED.toString().equals(tableTypeFromDS) && (tableType != null ? !tableType.equals(tableTypeFromDS) : tableTypeFromDS != null)) {
            String name = dataTable.getName() + "." + selectedColumn.getName();
            context.addError((CdErrorCode)OlapBuilderErrorCode.COLUMN_HAS_INCORRECT_TYPE, new Serializable[]{name, tableType, tableTypeFromDS});
        }
    }
}

