/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonReader;
import org.bson.codecs.Decoder;

public final class DecoderContext {
    private static final DecoderContext DEFAULT_CONTEXT = DecoderContext.builder().build();
    private final boolean checkedDiscriminator;

    private DecoderContext(Builder builder) {
        this.checkedDiscriminator = builder.hasCheckedDiscriminator();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasCheckedDiscriminator() {
        return this.checkedDiscriminator;
    }

    public <T> T decodeWithChildContext(Decoder<T> decoder, BsonReader reader) {
        return decoder.decode(reader, DEFAULT_CONTEXT);
    }

    public static final class Builder {
        private boolean checkedDiscriminator;

        private Builder() {
        }

        public boolean hasCheckedDiscriminator() {
            return this.checkedDiscriminator;
        }

        public Builder checkedDiscriminator(boolean checkedDiscriminator) {
            this.checkedDiscriminator = checkedDiscriminator;
            return this;
        }

        public DecoderContext build() {
            return new DecoderContext(this);
        }
    }
}

